package ru.yandex.autotests.directintapi.bstransport.main.dynbanner.parameters.bannerland;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.DynamicConditionsRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.dynamicadgroups.ConditionData;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.dynamicadgroups.TargetDataDynamic;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.BannerLandDataDynamic;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.isEmptyString;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-42105")
@Title("Транспорт: проверка отправки в БК BannerLandData для дин. баннера c UpdateInfo=1, поле Targets" +
        ", несколько условий")
@Stories(StoriesNames.DYN_BANNER_PARAMS_BANNERLAND)
@Features(FeatureNames.DYN_BANNERS)
public class BsTransportOfBannerLandDataTargetsMultipleConditionsTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    private Long cid;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Step("Подготовка данных для теста")
    @Before
    public void before() {
        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
    }

    @Test
    @Description("Два объекта Condition в одном Target")
    public void testBannerLandDataMultipleConditions() {
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addWebpage(new WebpageAddItemMap()
                .withAdGroupId(pid)
                .withName("Name")
                .withConditions(new WebpageConditionMap()
                                .withOperand(WebpageConditionOperandEnum.PAGE_CONTENT)
                                .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                .withArguments("someString"),
                        new WebpageConditionMap()
                                .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                                .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                                .withArguments("someString")));
        Long bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Banner banner
                = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid).getContext(pid).getBanner(bid);

        assumeThat("в БК отправлен баннер", banner, notNullValue());
        assumeThat("UpdateInfo отправленного баннера " + UpdateInfo.UPDATE
                , banner.getUpdateInfo(), equalTo(UpdateInfo.UPDATE.value()));
        assumeThat("отправленное поле BannerLandData не пустое", banner.getBannerLandData(), not(isEmptyString()));

        String bannerLand = banner.getBannerLandData().replaceAll("\\\\", "");
        BannerLandDataDynamic bannerLandDataDynamic = JsonUtils.getObject(bannerLand, BannerLandDataDynamic.class);

        DynamicConditionsRecord condition = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .dynamicConditionsSteps()
                .getDynamicConditionByAdgroupId(pid);

        TargetDataDynamic targetData = new TargetDataDynamic();
        targetData.setDynamicConditionId(condition.getDynCondId());
        targetData.setCondition(
                Arrays.asList(JsonUtils.getObject(condition.getConditionJson(), ConditionData[].class)));

        List<TargetDataDynamic> targetDataList = new ArrayList<>();
        targetDataList.add(targetData);

        assertThat("отправленное в БК поле BannerLandData.Targets соответствуют ожидаемому",
                bannerLandDataDynamic.getTargets(), beanEquivalent(targetDataList));
    }

    @Test
    @Description("Два объекта Target")
    public void testBannerLandDataMultipleTargets() {
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addWebpage(new WebpageAddItemMap()
                .withAdGroupId(pid)
                .withName("Name")
                .withConditions(new WebpageConditionMap()
                        .withOperand(WebpageConditionOperandEnum.PAGE_CONTENT)
                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                        .withArguments("someString")));
        api.userSteps.dynamicTextAdTargetsSteps().addWebpage(new WebpageAddItemMap()
                .withAdGroupId(pid)
                .withName("Name")
                .withConditions(new WebpageConditionMap()
                        .withOperand(WebpageConditionOperandEnum.PAGE_TITLE)
                        .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                        .withArguments("someString")));
        Long bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Banner banner
                = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid).getContext(pid).getBanner(bid);


        assumeThat("в БК отправлен баннер", banner, notNullValue());
        assumeThat("UpdateInfo отправленного баннера " + UpdateInfo.UPDATE
                , banner.getUpdateInfo(), equalTo(UpdateInfo.UPDATE.value()));
        assumeThat("отправленное поле BannerLandData не пустое", banner.getBannerLandData(), not(isEmptyString()));

        String bannerLand = banner.getBannerLandData().replaceAll("\\\\", "");
        BannerLandDataDynamic bannerLandDataDynamic = JsonUtils.getObject(bannerLand, BannerLandDataDynamic.class);

        List<DynamicConditionsRecord> conditions = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .dynamicConditionsSteps()
                .getDynamicConditionsByAdgroupId(pid);

        assumeThat("список полученных из базы условий нацеливания правильной длины", conditions, hasSize(2));

        TargetDataDynamic targetData1 = new TargetDataDynamic();
        targetData1.setDynamicConditionId(conditions.get(0).getDynCondId());
        targetData1.setCondition(
                Arrays.asList(JsonUtils.getObject(conditions.get(0).getConditionJson(), ConditionData[].class)));
        TargetDataDynamic targetData2 = new TargetDataDynamic();
        targetData2.setDynamicConditionId(conditions.get(1).getDynCondId());
        targetData2.setCondition(
                Arrays.asList(JsonUtils.getObject(conditions.get(1).getConditionJson(), ConditionData[].class)));

        assertThat("количество целей отправленных в БК в поле BannerLandData.Targets соответствуют ожидаемому",
                bannerLandDataDynamic.getTargets().size(), Matchers.equalTo(2));
        assertThat("отправленное в БК поле BannerLandData.Targets соответствуют ожидаемому",
                bannerLandDataDynamic.getTargets()
                , containsInAnyOrder(beanEquivalent(targetData1), beanEquivalent(targetData2)));
    }
}
