package ru.yandex.autotests.directintapi.bstransport.main.dynbanner.parameters.bannerland;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.DynamicConditionsRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.dynamicadgroups.ConditionData;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.dynamicadgroups.TargetDataDynamic;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.BannerLandDataDynamic;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.dynamictextadtargets.WebpageConditionMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.Matchers.isEmptyString;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-42105")
@Title("Транспорт: проверка отправки в БК BannerLandData для дин. баннера c UpdateInfo=1, поле Targets, Kind")
@Stories(StoriesNames.DYN_BANNER_PARAMS_BANNERLAND)
@Features(FeatureNames.DYN_BANNERS)
@RunWith(Parameterized.class)
public class BsTransportOfBannerLandDataTargetsSingleConditionKindTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    private Banner banner;
    private Long pid;

    @Parameterized.Parameter(0)
    public StringConditionOperatorEnum kind;

    @Parameterized.Parameter(1)
    public WebpageConditionOperandEnum operand;

    @Parameterized.Parameters(name = "kind = {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {StringConditionOperatorEnum.CONTAINS_ANY, WebpageConditionOperandEnum.DOMAIN},
                {StringConditionOperatorEnum.NOT_CONTAINS_ALL, WebpageConditionOperandEnum.DOMAIN},
                {StringConditionOperatorEnum.EQUALS_ANY, WebpageConditionOperandEnum.OFFERS_LIST_URL},
                {StringConditionOperatorEnum.NOT_EQUALS_ALL, WebpageConditionOperandEnum.OFFERS_LIST_URL}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Step("Подготовка данных для теста")
    @Before
    public void before() {
        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addWebpage(new WebpageAddItemMap()
                .withAdGroupId(pid)
                .withName("Name")
                .withConditions(new WebpageConditionMap()
                        .withOperand(operand)
                        .withOperator(kind)
                        .withArguments("http://someString.ru")));
        Long bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        banner = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid).getContext(pid).getBanner(bid);
    }

    @Test
    @Title("Отправка в БК BannerLandData для дин. баннера")
    public void testBannerLandData() {
        assumeThat("в БК отправлен баннер", banner, notNullValue());
        assumeThat("UpdateInfo отправленного баннера " + UpdateInfo.UPDATE
                , banner.getUpdateInfo(), equalTo(UpdateInfo.UPDATE.value()));
        assumeThat("отправленное поле BannerLandData не пустое", banner.getBannerLandData(), not(isEmptyString()));

        String bannerLand = banner.getBannerLandData().replaceAll("\\\\", "");
        BannerLandDataDynamic bannerLandDataDynamic = JsonUtils.getObject(bannerLand, BannerLandDataDynamic.class);

        DynamicConditionsRecord condition = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .dynamicConditionsSteps()
                .getDynamicConditionByAdgroupId(pid);

        TargetDataDynamic targetData = new TargetDataDynamic();
        targetData.setDynamicConditionId(condition.getDynCondId());
        targetData.setCondition(
                Arrays.asList(JsonUtils.getObject(condition.getConditionJson(), ConditionData[].class)));

        List<TargetDataDynamic> targetDataList = new ArrayList<>();
        targetDataList.add(targetData);

        assertThat("отправленное в БК поле BannerLandData.Targets соответствуют ожидаемому",
                bannerLandDataDynamic.getTargets(), beanEquivalent(targetDataList));
    }
}
