package ru.yandex.autotests.directintapi.bstransport.main.dynbanner.parameters.bannerland;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.BannerLandDataDynamic;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.BannerLandDataFilter;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.Matchers.isEmptyString;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-158191")
@Title("Транспорт: проверка отправки в БК BannerLandData для дин. баннера в текстовой группе c UpdateInfo=1, поле Filter" +
        ", несколько условий")
@Stories(StoriesNames.DYN_BANNER_PARAMS_BANNERLAND)
@Features(FeatureNames.DYN_BANNERS)
public class BsTransportOfTGOFeedDynamicBannerLandDataFilterBannerTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    private Long cid;
    private Long pid;
    private Long bid;
    private Long feedId;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Step("Подготовка данных для теста")
    @Before
    public void before() {
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps()
                .setBannersBannerType(bid, BannersBannerType.dynamic);

        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        feedId = api.userSteps.getDirectJooqDbSteps().useShard(shard).feedsSteps()
                .createDefaultFeed(User.get(LOGIN).getClientID());
        api.userSteps.getDirectJooqDbSteps().useShard(shard).feedsSteps()
                .updateFeedLogin(feedId, User.get(LOGIN).getClientID(), "login");

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
    }

    @Test
    @Description("Два объекта Condition в одном Filter")
    public void testBannerLandDataMultipleConditions() {
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps()
                .setAdgroupsTextFeedIdAndFilter(pid, feedId,
                        "{\"fromTab\": \"tree\", \"conditions\": [{\"value\": " +
                                "{\"[double]\": [1.04, 2.75]}, \"operator\": \"==\", \"fieldName\": \"price\"}," +
                                "{\"value\": {\"[range]\": [\"14.03-15.89\"]}, \"operator\": \"<->\", \"fieldName\": " +
                                "\"oldprice\"}]}");

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Banner banner = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, cid).getContext(pid).getBanner(bid);

        assumeThat("в БК отправлен баннер", banner, notNullValue());
        assumeThat("UpdateInfo отправленного баннера " + UpdateInfo.UPDATE
                , banner.getUpdateInfo(), equalTo(UpdateInfo.UPDATE.value()));
        assumeThat("отправленное поле BannerLandData не пустое", banner.getBannerLandData(), not(isEmptyString()));

        String bannerLand = banner.getBannerLandData().replaceAll("\\\\", "");
        BannerLandDataDynamic bannerLandDataDynamic = JsonUtils.getObject(bannerLand, BannerLandDataDynamic.class);

        BannerLandDataFilter expectedBannerLandDataFilter = new BannerLandDataFilter();
        Map<String, Object> map = new HashMap<>();
        map.put("price ==", Arrays.asList(1.04, 2.75));
        map.put("oldprice <->", Arrays.asList("14.03-15.89"));
        expectedBannerLandDataFilter.setCondition(map);

        assertThat("отправленное в БК поле BannerLandData.Filter соответствуют ожидаемому",
                bannerLandDataDynamic.getFilter(), beanDiffer(expectedBannerLandDataFilter));
    }

    @After
    public void clearFeed() {
        if (feedId > 0) {
            api.userSteps.getDirectJooqDbSteps().useShard(shard).feedsSteps().deleteFeedAndAllLinksByFeedId(feedId);
        }
    }
}
