package ru.yandex.autotests.directintapi.bstransport.main.dynbanner.parameters.bannerland.feed;

import java.util.Arrays;
import java.util.Collection;

import com.google.gson.Gson;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.FeedsBusinessType;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.BannerLandDataDynamicFeed;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;


@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-66898")
@Title("Транспорт: проверка отправки в БК BannerLandData для дин. баннера по фиду, поле BusinessType")
@Stories(StoriesNames.DYN_BANNER_PARAMS_BANNERLAND)
@Features(FeatureNames.DYN_BANNERS)
@RunWith(Parameterized.class)
public class BsTransportOfFeedDTOBannerLandDataFeedBusinessTypeTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static int shard;

    @Rule
    public Trashman trashman = new Trashman(api);

    private Banner banner;
    private long feedId;

    @Parameterized.Parameter(0)
    public FeedsBusinessType feedBusinessType;

    @Parameterized.Parameters(name = "Feed login = {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {FeedsBusinessType.retail},
                {FeedsBusinessType.hotels},
                {FeedsBusinessType.realty},
                {FeedsBusinessType.auto},
                {FeedsBusinessType.flights},
                {FeedsBusinessType.news}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void before() {
        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        Long bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);
        feedId = api.userSteps.getDirectJooqDbSteps().useShard(shard).feedsSteps()
                .createDefaultFeed(User.get(LOGIN).getClientID());
        api.userSteps.getDirectJooqDbSteps().useShard(shard).feedsSteps()
                .updateFeedBusinessType(feedId, User.get(LOGIN).getClientID(), feedBusinessType);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().setAdgroupsDynamicDomainId(pid, null);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().setAdgroupsDynamicFeedId(pid, feedId);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        banner = context != null ? context.getBanner(bid) : null;
        assumeThat("в БК отправлен баннер", banner, notNullValue());
    }

    @Test
    @Title("Отправка в БК BannerLandData для дин. баннера")
    public void testBannerLandData() {
        assumeThat("в БК отпралено поле BannerLandData", banner.getBannerLandData(), notNullValue());
        BannerLandDataDynamicFeed bannerLandData = new Gson().fromJson(banner.getBannerLandData()
                , BannerLandDataDynamicFeed.class);
        assertThat("в БК на уровне BANNER отправилось поле BannerLandData с правильным BusinessType"
                , bannerLandData.getBusinessType()
                , equalTo(feedBusinessType));
    }

    @After
    public void clearFeed() {
        if (feedId > 0) {
            api.userSteps.getDirectJooqDbSteps().useShard(shard).feedsSteps().deleteFeedAndAllLinksByFeedId(feedId);
        }
    }
}
