package ru.yandex.autotests.directintapi.bstransport.main.dynbanner.parameters.bannerland.feed;

import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.BannerLandDataDynamicFeed;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.Matchers.isEmptyString;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;
import static ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies.onlyExpectedFields;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-171708")
@Title("Транспорт: проверка отправки в БК BannerLandData для дин. баннера c UpdateInfo=1, поля use_as")
@Stories(StoriesNames.DYN_BANNER_PARAMS_BANNERLAND)
@Features(FeatureNames.DYN_BANNERS)
public class BsTransportOfFeedDTOBannerLandDataUseAsTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final String USE_AS_NAME = "name";
    private static final String USE_AS_BODY = "body";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static int shard;
    private Banner banner;
    private long feedId;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void before() {
        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        Long bid = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withDynamicTextAd(new DynamicTextAdAddMap()
                        .defaultDynamicTextAd()));

        feedId = api.userSteps.getDirectJooqDbSteps().useShard(shard).feedsSteps()
                .createDefaultFeed(User.get(LOGIN).getClientID());
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps()
                .convertAdgroupDynamicToDynamicByFeed(pid, feedId);

        api.userSteps.getDirectJooqDbSteps().useShard(shard).adgroupsDynamicSteps()
                .setUseAsFieldsDynamic(pid, USE_AS_NAME, USE_AS_BODY);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps()
                .sendNewCampaign(shard, cid);

        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        banner = context != null ? context.getBanner(bid) : null;
    }

    @Test
    @Title("Отправка в БК BannerLandData для динамического баннера")
    public void testBannerLandData() {
        assumeThat("в БК отправлен баннер", banner, notNullValue());
        assumeThat("UpdateInfo отправленного баннера " + UpdateInfo.UPDATE,
                banner.getUpdateInfo(), equalTo(UpdateInfo.UPDATE.value()));
        assumeThat("отправленное поле BannerLandData не пустое",
                banner.getBannerLandData(), not(isEmptyString()));

        BannerLandDataDynamicFeed bannerLandData = JsonUtils.getObject(banner.getBannerLandData(), BannerLandDataDynamicFeed.class);
        BannerLandDataDynamicFeed expectedBannerLandData = new BannerLandDataDynamicFeed();
        expectedBannerLandData.setUseAsName(USE_AS_NAME);
        expectedBannerLandData.setUseAsBody(USE_AS_BODY);

        assertThat("отправленные в БК поля UseAsName и UseAsBody соответствуют ожидаемым",
                bannerLandData, beanDiffer(expectedBannerLandData).useCompareStrategy(onlyExpectedFields()));
    }

    @After
    public void clearFeed() {
        if (feedId > 0) {
            api.userSteps.getDirectJooqDbSteps().useShard(shard).feedsSteps().deleteFeedAndAllLinksByFeedId(feedId);
        }
    }
}
