package ru.yandex.autotests.directintapi.bstransport.main.dynbanner.parameters.excess;

import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ClientDataStdLogEntry;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ClientDataStdRequest;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasItem;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка не-отправки в БК лишних полей дин. баннера")
@Stories(StoriesNames.DYN_BANNER_PARAMS_EXCESS)
@Features(FeatureNames.DYN_BANNERS)
public class BsTransportOfExcessFieldsInNewDynBannerTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    private static Map<String, Object> banner;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        Long bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Map<String, Map> logs = api.userSteps.getDarkSideSteps().getTransportSteps().getRawClientDataLogEntriesForCampaign(resp, cid);

        // достаем сырой баннер из первого запроса
        Map<String, Map> logEntry = logs.get(resp.getUuid()[0]);
        Map<String, Map> request = logEntry != null ?
                logEntry.get(ClientDataStdLogEntry.REQUEST) : null;
        Map<String, Map> orders = request != null ?
                request.get(ClientDataStdRequest.ORDERS) : null;
        Map<String, Map> order = orders != null ?
                orders.get("" + cid) : null;
        Map<String, Map> contexts = order != null ?
                order.get(Campaign.CONTEXTS) : null;
        Map<String, Map> context = contexts != null ?
                contexts.get("" + pid) : null;
        Map<String, Map> banners = context != null ?
                context.get(Context.BANNERS) : null;

        banner = banners != null ? banners.get("" + bid) : null;

        assumeThat("в БК отправлен баннер", banner, notNullValue());
    }

    @Test
    @Title("Не-отправка в БК в динамическом баннере поля Title")
    public void testTransportOfDynBannerTitle() {
        assertThat("в динамическом баннере не отправлено поле Title",
                banner.keySet(), not(hasItem(Banner.TITLE)));
    }

    @Test
    @Title("Не-отправка в БК в динамическом баннере поля Lang")
    public void testTransportOfDynBannerLang() {
        assertThat("в динамическом баннере не отправлено поле Lang",
                banner.keySet(), not(hasItem(Banner.LANG)));
    }

    @Test
    @Title("Не-отправка в БК в динамическом баннере поля Href")
    public void testTransportOfDynBannerHref() {
        assertThat("в динамическом баннере не отправлено поле Href",
                banner.keySet(), not(hasItem(Banner.HREF)));
    }

    @Test
    @Title("Не-отправка в БК в динамическом баннере поля Site")
    public void testTransportOfDynBannerSite() {
        assertThat("в динамическом баннере не отправлено поле Site",
                banner.keySet(), not(hasItem(Banner.SITE)));
    }

    @Test
    @Title("Не-отправка в БК в динамическом баннере поля SiteFilter")
    public void testTransportOfDynBannerSiteFilter() {
        assertThat("в динамическом баннере не отправлено поле SiteFilter",
                banner.keySet(), not(hasItem(Banner.SITE_FILTER)));
    }

    @Test
    @Title("Не-отправка в БК в динамическом баннере поля DomainFilter")
    public void testTransportOfDynBannerDomainFilter() {
        assertThat("в динамическом баннере не отправлено поле DomainFilter",
                banner.keySet(), not(hasItem(Banner.DOMAIN_FILTER)));
    }

    @Test
    @Title("Не-отправка в БК в динамическом баннере поля HrefText")
    public void testTransportOfDynBannerHrefText() {
        assertThat("в динамическом баннере не отправлено поле HrefText",
                banner.keySet(), not(hasItem(Banner.HREF_TEXT)));
    }
}
