package ru.yandex.autotests.directintapi.bstransport.main.dyngroup;

import java.util.List;
import java.util.Map;

import com.yandex.direct.api.v5.general.AgeRangeEnum;
import com.yandex.direct.api.v5.general.GenderEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.direct.web.api.core.DirectRule;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.RetargetingCoef;
import ru.yandex.autotests.directapi.enums.AgeGroup;
import ru.yandex.autotests.directapi.enums.Gender;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.DemographicsAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.MobileAdjustmentMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RetargetingAdjustmentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.DefaultMatchVariation;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getDefaultSocdemCoef;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 03/07/15.
 */
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки корректировок на уровне группы для динамических групп")
@Stories(StoriesNames.DYN_GROUP_COEF)
@Features(FeatureNames.DYN_GROUPS)
public class BsTransportOfCoefDynamicTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public DirectRule directRule = DirectRule.defaultRule().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;
    private static List<Long> retIds;

    private Long pid;
    private Long cid;

    private Context context;

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        retIds = helpSteps.addRetargetingListsForUserIfNotExists(LOGIN);
    }

    @Before
    public void prepare() {
        helpSteps.useDirectWebApiSteps(directRule.webApiSteps());
        cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        Long bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
    }

    @Test
    @Title("Отправка в БК корректировки MobilePriceCoef на уровне группы, динамика")
    public void testTransportOfMobilePriceCoefDynamic() {
        Integer coef = 50;

        api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap().withAdGroupId(pid).withMobileAdjustment(
                        new MobileAdjustmentMap()
                                .withBidModifier(coef)
                )
        );

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        assumeThat("в БК отправлен контекст (группа)", context, notNullValue());
        String expectedMobilePriceCoeff = coef.toString();
        assertThat("отправленная в БК корректировка MobilePriceCoef на уровне группы соответствует ожидаемой",
                context.getMobilePriceCoef(), equalTo(expectedMobilePriceCoeff));
    }

    @Test
    @Title("Отправка в БК корректировки SocdemCoef на уровне группы, динамика")
    public void testTransportOfSocdemCoefDynamic() {
        Integer coef = 150;

        api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap().withAdGroupId(pid).withDemographicsAdjustment(
                        new DemographicsAdjustmentMap()
                                .withBidModifier(coef)
                                .withAge(AgeRangeEnum.AGE_0_17)
                                .withGender(GenderEnum.GENDER_FEMALE)
                )
        );

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Map<String, Map> expected = getDefaultSocdemCoef();
        expected.get(Gender.FEMALE.toString()).put(AgeGroup.CHILD.toString(), coef);
        Map<String, Map> contextMap = helpSteps.getContextMap(resp, cid, pid);
        assumeThat("в БК отправлен контекст (группа)", contextMap, notNullValue());
        assertThat("отправленная в БК корректировка SocdemCoef на уровне группы соответствует ожидаемой",
                contextMap.get(Context.SOCDEM_COEF)
                , BeanDifferMatcher.beanDiffer(expected).withVariation(
                        new DefaultMatchVariation()
                                .setIgnoreNullFieldsOfExpectedBean(false)
                )
        );
    }

    @Test
    @Title("Отправка в БК корректировки RetargetingCoef на уровне группы, динамика")
    public void testTransportOfRetargetingCoefDynamic() {
        Integer coef = 150;

        api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap().withAdGroupId(pid).withRetargetingAdjustment(
                        new RetargetingAdjustmentMap()
                                .withBidModifier(coef)
                                .withRetargetingConditionId(retIds.get(0))
                )
        );

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        assumeThat("в БК отправлен контекст (группа)", context, notNullValue());

        RetargetingCoef expected = new RetargetingCoef();
        expected.setCoef(coef);
        expected.setExpression(helpSteps.getRetConditionsBSStyle(retIds.get(0)));
        assertThat("отправленная в БК корректировка RetargetingCoef на уровне группы содержит ровно одну запись",
                context.getRetargetingCoef().size(), equalTo(1));
        assertThat("отправленная в БК корректировка RetargetingCoef на уровне группы соответствует ожидаемой",
                context.getRetargetingCoef().get(String.valueOf(retIds.get(0))), beanEquals(expected));
    }
}
