package ru.yandex.autotests.directintapi.bstransport.main.dyngroup;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsDynamicRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Dynamic;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК синхронизированного нацеливания " +
        "со статусом statusBsSynced=Yes")
@Stories(StoriesNames.DYN_GROUP_ACTION_EDITION)
@Features(FeatureNames.DYN_GROUPS)
public class BsTransportOfSyncedDynamicTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long pid;
    private static Long dynId;

    private static Context context;
    private static Dynamic dynamic;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        Long bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        BidsDynamicRecord bidsDynamicRecord = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bidsDynamicSteps()
                .getBidsDynamicByPid(pid)
                .get(0);
        dynId = bidsDynamicRecord.getDynId();
        Long dynCondId = bidsDynamicRecord.getDynCondId();

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, Status.NO);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        dynamic = context != null ? context.getDynamic(dynCondId) : null;
    }

    @Test
    @Title("Отправка в БК отредактированного нацеливания - проверка объекта Контекст")
    public void testTransportOfContextObjReq1() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленный в БК контекст соответствует ожидаемому",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК отредактированного нацеливания - проверка объекта Нацеливание")
    public void testTransportOfDynamicObjReq1() {
        Dynamic expectedDynamic = helpSteps.buildExpectedDynamicObjFromDb(dynId, shard, UpdateInfo.UPDATE);
        assertThat("отправленное в БК нацеливание соответствует ожидаемому",
                dynamic, beanEquals(expectedDynamic));
    }
}
