package ru.yandex.autotests.directintapi.bstransport.main.dyngroup;

import java.util.HashMap;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by n-boy on 06.12.16.
 * https://st.yandex-team.ru/TESTIRT-8623
 */
@Aqua.Test
@Title("Транспорт: проверка отправки в БК старой ДО группы " +
        "без условий нацеливания")
@Stories(StoriesNames.DYN_GROUP_ACTION_EDITION)
@Features({FeatureNames.DYN_GROUPS, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/DIRECT-54263")
public class BsTransportOfSyncedDynamicWithoutShowConditionsTest {
    protected static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static Long bid;
    private static Context context;

    @BeforeClass
    public static void beforeClass() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(login);

        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Long dynCondId = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bidsDynamicSteps()
                .getBidsDynamicCondIdsByPid(pid)
                .get(0);
        api.userSteps.dynamicTextAdTargetsSteps().dynamicTextAdTargetsDelete(dynCondId, login);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        assumeThat("в БК отправлена кампания", campaign, notNullValue());
        context = campaign.getContext(pid);
    }

    @Test
    @Title("Отправка в БК ранее синхронизированной ДО группы, после удаления всех условий нацеливания")
    public void testTransportOfSyncedDynamicWithDeletedAllShowConditions() {
        assertThat("группа после удаления всех фраз успешно ушла в БК", context, notNullValue());

    }

    @Test
    @Title("Отправка в БК ранее синхронизированной ДО группы, после удаления всех условий нацеливания, проверяем UpdateInfo")
    public void testTransportOfSyncedDynamicWithDeletedAllShowConditionsCheckUpdateInfo() {
        assertThat("группа после удаления всех условий нацеливания успешно ушла в БК, с UpdateInfo=1",
                context!=null ? context.getUpdateInfo() : null, equalTo(1));

    }

    @Test
    @Title("Отправка в БК ранее синхронизированной ДО группы, после удаления всех условий нацеливания, проверяем поля с условиями показа")
    public void testTransportOfSyncedDyncamicWithDeletedAllShowConsitionsCheckShowConditions() {
        checkEmptyShowConditionsIsSent(context);
    }

    @Test
    @Title("Отправка в БК ранее синхронизированной ДО группы, после удаления всех условий нацеливания, проверяем BANNER")
    public void testTransportOfSyncedDynamicWithDeletedAllShowConditionsCheckBanner() {
        Banner banner = context != null ? context.getBanner(bid) : null;
        assumeThat("после удаления всех условий нацеливания, синхронизированный ранее баннер успешно ушел в БК",
                banner, notNullValue());

        Banner expectedBanner = new Banner();
        expectedBanner.setStop(0);
        expectedBanner.setUpdateInfo(1);
        assertThat("после удаления всех условий нацеливания, синхронизированный ранее баннер успешно ушел в БК с UpdateInfo=1, Stop=0",
                banner, beanDiffer(expectedBanner).useCompareStrategy(
                        DefaultCompareStrategies.onlyExpectedFields()));
    }

    @Step("Проверяем что поля со всеми типами условий показа отправились, и списки условий - пустые")
    private void checkEmptyShowConditionsIsSent(Context context) {
        Context expectedContext = new Context();
        expectedContext.setPhrases(new HashMap<>());
        expectedContext.setGoalContexts(new HashMap<>());
        expectedContext.setDynamics(new HashMap<>());
        expectedContext.setFilters(new HashMap<>());

        assertThat("группа отправлена с полями для всех типов условий показа, при этом списки условий пустые",
                context, beanDiffer(expectedContext).useCompareStrategy(
                        DefaultCompareStrategies.onlyExpectedFields()));
    }

}
