package ru.yandex.autotests.directintapi.bstransport.main.dynimage.creating.receive;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerImagesRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.ImageType;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.isEmptyOrNullString;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка изменений после успешной отправки " +
        "новой картинки в новом дин. баннере")
@Stories(StoriesNames.DYN_IMAGE_ACTION_CREATION)
@Features({FeatureNames.DYN_IMAGES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsResponseHandlingForNewPicInNewDynBannerTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long pid;
    private static Long picBid;
    private static Long imageId;

    private static Banner picBanner;
    private static Banner pic;


    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        String[] imageHashes = helpSteps.addImagesForUserIfNotExists(LOGIN, ImageType.REGULAR);

        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        picBid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(picBid);

        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withAds(new AdUpdateItemMap()
                        .withId(picBid)
                        .withDynamicTextAd(new DynamicTextAdUpdateMap().withAdImageHash(imageHashes[0]))),
                ExpectedResult.success());
        imageId = api.userSteps.getDirectJooqDbSteps().useShard(shard).
                imagesSteps().getBannerImagesByBid(picBid).getImageId();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).imagesSteps().setBannerImagesStatusModerate(imageId, BannerImagesStatusmoderate.Yes);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataResponseCampaign(resp, 0, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        picBanner = context != null ? context.getBanner(picBid) : null;
        pic = context != null ? context.getBanner(imageId) : null;
    }

    @Test
    @Title("Изменения после успешной отправки новой картинки в новом дин. баннере - " +
            "статус statusBsSynced Группы")
    public void testGroupSyncStatus() {
        PhrasesRecord dbGroup = api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().getPhrases(pid);
        assertThat("после синхронизации группы statusBsSynced = Yes",
                dbGroup.getStatusbssynced().getLiteral(), equalTo(Status.YES));
    }

    @Test
    @Title("Изменения после успешной отправки новой картинки в новом дин. баннере - " +
            "статус statusBsSynced Баннера")
    public void testBannerSyncStatus() {
        BannersRecord dbBanner = api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().getBanner(picBid);
        assertThat("после синхронизации баннера statusBsSynced = Yes",
                dbBanner.getStatusbssynced().getLiteral(), equalTo(Status.YES));
    }

    @Test
    @Title("Изменения после успешной отправки новой картинки в новом дин. баннере - " +
            "BannerID Баннера")
    public void testBannerId() {
        String bannerId = picBanner.getId();
        assumeThat("БК вернула BannerID в ответе на первый запрос",
                bannerId, not(isEmptyOrNullString()));

        BannersRecord dbBanner = api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().getBanner(picBid);
        assertThat("правильный BannerID у баннера после синхронизации",
                dbBanner.getBannerid(), equalTo(Long.valueOf(bannerId)));
    }

    @Test
    @Title("Изменения после успешной отправки новой картинки в новом дин. баннере - " +
            "BannerID Картинки")
    public void testPicId() {
        String bannerId = pic.getId();
        assumeThat("БК вернула BannerID в ответе на первый запрос",
                bannerId, not(isEmptyOrNullString()));

        BannerImagesRecord bannerImagesRecord =  api.userSteps.getDirectJooqDbSteps().useShard(shard).imagesSteps().getBannerImages(imageId);
        assertThat("правильный BannerID у картинки после синхронизации",
                bannerImagesRecord.getBannerid().toString(), equalTo(bannerId));
    }
}
