package ru.yandex.autotests.directintapi.bstransport.main.dynimage.creating.transmit.moderation;

import java.util.List;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.ImageType;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Dynamic;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.directintapi.bstransport.TransportTestUtils;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@RunWith(Parameterized.class)
public class BsTransportOfNewPicInNewDynBannerWithNegBannerModerationBaseTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private Long pid;

    private Context context;
    private List<Dynamic> dynamics;
    private Banner picBanner;
    private Banner banner;
    private Banner pic;

    @Parameterized.Parameter
    public String testStatus;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    public void prepare() {
        String[] imageHashes = helpSteps.addImagesForUserIfNotExists(LOGIN, ImageType.REGULAR);

        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        Long bid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);
        Long picBid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(picBid);

        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withAds(new AdUpdateItemMap()
                        .withId(picBid)
                        .withDynamicTextAd(new DynamicTextAdUpdateMap().withAdImageHash(imageHashes[0]))),
                LOGIN,
                ExpectedResult.success());
        Long imageId = api.userSteps.getDirectJooqDbSteps().useShard(shard).
                imagesSteps().getBannerImagesByBid(picBid).getImageId();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).imagesSteps().setBannerImagesStatusModerate(imageId, BannerImagesStatusmoderate.Yes);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusModerate(picBid, Status.YES);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusPostModerate(picBid, testStatus);

        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, Status.NO);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        dynamics = TransportTestUtils.getMapValues(context != null ? context.getDynamics() : null);
        banner = context != null ? context.getBanner(bid) : null;
        picBanner = context != null ? context.getBanner(picBid) : null;
        pic = context != null ? context.getBanner(imageId) : null;
    }

    @Test
    @Title("Не-отправка в БК новой картинки в новом дин. баннере с непройденной модерацией - " +
            "проверка объекта Контекст")
    public void testTransportOfContextObj() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Не-отправка в БК новой картинки в новом дин. баннере с непройденной модерацией - " +
            "проверка списка Нацеливаний")
    public void testTransportOfDynamicsList() {
        assertThat("в БК отправлен не пустой список нацеливаний", dynamics, not(empty()));
    }

    @Test
    @Title("Не-отправка в БК новой картинки в новом дин. баннере с непройденной модерацией - " +
            "проверка объекта Баннер")
    public void testTransportOfNewBanner() {
        assertThat("в БК отправлен новый баннер", banner, notNullValue());
    }

    @Test
    @Title("Не-отправка в БК новой картинки в новом дин. баннере с непройденной модерацией - " +
            "проверка объекта Баннер (с картинкой, с отрицательным статусом мод.)")
    public void testTransportOfNewPicBanner() {
        assertThat("в БК не отправлен новый баннер", picBanner, nullValue());
    }

    @Test
    @Title("Не-отправка в БК новой картинки в новом дин. баннере с непройденной модерацией - " +
            "проверка объекта Картинка")
    public void testTransportOfNewPic() {
        assertThat("в БК не отправлена новая картинка", pic, nullValue());
    }
}
