package ru.yandex.autotests.directintapi.bstransport.main.dynimage.creating.transmit.req2;

import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.ImageType;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Dynamic;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.isEmptyOrNullString;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК новой картинки " +
        "в синхронизированном дин. баннере (2 запрос)")
@Stories(StoriesNames.DYN_IMAGE_ACTION_CREATION)
@Features({FeatureNames.DYN_IMAGES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewPicInSyncedBannerTest {

    //DIRECT-49876

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long pid;
    private static Long imageId;

    private static Banner picResp1;

    private static Context contextReq2;
    private static Collection<Dynamic> dynamicsReq2;
    private static Banner picBannerReq2;
    private static Banner picReq2;


    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        String[] imageHashes = helpSteps.addImagesForUserIfNotExists(LOGIN, ImageType.REGULAR);

        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        Long picBid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(picBid);


        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap().withAds(new AdUpdateItemMap()
                .withId(picBid)
                .withDynamicTextAd(new DynamicTextAdUpdateMap().withAdImageHash(imageHashes[0]))));
        imageId = api.userSteps.getDirectJooqDbSteps().useShard(shard).
                imagesSteps().getBannerImagesByBid(picBid).getImageId();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).imagesSteps()
                .setBannerImagesStatusModerateByBid(picBid, BannerImagesStatusmoderate.Yes);
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, Status.NO);//до починки DIRECT-49882

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);

        Campaign campaignResp1 = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataResponseCampaign(resp, 0, cid);
        Context contextResp1 = campaignResp1 != null ? campaignResp1.getContext(pid) : null;
        picResp1 = contextResp1 != null ? contextResp1.getBanner(imageId) : null;

        Campaign campaignReq2 = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 1, cid);
        contextReq2 = campaignReq2 != null ? campaignReq2.getContext(pid) : null;
        dynamicsReq2 = contextReq2 != null &&
                contextReq2.getDynamics() != null &&
                contextReq2.getDynamics().values().size() > 0 ?
                contextReq2.getDynamics().values() : null;
        picBannerReq2 = contextReq2 != null ? contextReq2.getBanner(picBid) : null;
        picReq2 = contextReq2 != null ? contextReq2.getBanner(imageId) : null;
    }

    @Test
    @Title("Отправка в БК новой картинки в синхронизированном дин. баннере (2 запрос) - " +
            "проверка объекта Контекст")
    public void testTransportOfContextObjReq2() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.SKIP);
        assertThat("отправленные в БК данные группы соответствуют ожидаемым",
                contextReq2, beanEquals(expectedContext));
    }

    @Test
    @Title("Отправка в БК новой картинки в синхронизированном дин. баннере (2 запрос) - " +
            "проверка списка Нацеливаний")
    public void testTransportOfDynamicsListReq2() {
        assertThat("в БК не отправлены нацеливания", dynamicsReq2, nullValue());
    }

    @Test
    @Title("Отправка в БК новой картинки в синхронизированном дин. баннере (2 запрос) - " +
            "проверка объекта Баннер (синхронизированный)")
    public void testTransportOfSyncedBannerObjReq2() {
        assertThat("в БК не отправлен синхронизированный баннер", picBannerReq2, nullValue());
    }

    @Test
    @Title("Отправка в БК новой картинки в синхронизированном дин. баннере (2 запрос) - " +
            "проверка объекта Картинка")
    public void testTransportOfNewPicObjReq2() {
        String bannerId = picResp1.getId();
        assumeThat("БК вернула BannerID в ответе на первый запрос",
                bannerId, not(isEmptyOrNullString()));

        Banner expectedPicBanner = helpSteps.buildExpectedPicBannerObjFromDb(imageId, shard, UpdateInfo.SKIP);
        expectedPicBanner.setId(bannerId);
        expectedPicBanner.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные новой картинки соответствуют ожидаемым",
                picReq2, beanEquals(expectedPicBanner));
    }
}
