package ru.yandex.autotests.directintapi.bstransport.main.dynimage.parameters.flags;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.ImageType;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ClientDataStdLogEntry;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ClientDataStdRequest;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК параметра Age (возрастная метка) " +
        "для картинки дин. баннера")
@Stories(StoriesNames.DYN_IMAGE_PARAMS_FLAGS)
@Features(FeatureNames.DYN_IMAGES)
@RunWith(Parameterized.class)
public class BsTransportOfAgeTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final String PARAM_AGE = "Age";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    @Parameterized.Parameter(0)
    public String flagsDb;

    private Map<String, Object> picReq1;
    private Map<String, Object> picReq2;


    @Parameterized.Parameters(name = "Флаги модерации в БД = {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {null},
                {"abortion"},
                {"age:18"},
                {"alcohol,age:6,dietarysuppl"}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @SuppressWarnings("unchecked")
    public void prepare() {
        String[] imageHashes = helpSteps.addImagesForUserIfNotExists(LOGIN, ImageType.REGULAR);

        Long cid = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        Long picBid = api.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(picBid);

        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withAds(new AdUpdateItemMap()
                        .withId(picBid)
                        .withDynamicTextAd(new DynamicTextAdUpdateMap().withAdImageHash(imageHashes[0]))),
                ExpectedResult.success());
        Long imageId = api.userSteps.getDirectJooqDbSteps().useShard(shard).
                imagesSteps().getBannerImagesByBid(picBid).getImageId();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).
                imagesSteps().setBannerImagesStatusModerate(imageId, BannerImagesStatusmoderate.Yes);

        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps().setBannersFlags(picBid, flagsDb);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Map<String, Map> logs =
                api.userSteps.getDarkSideSteps().getTransportSteps().getRawClientDataLogEntriesForCampaign(resp, cid);

        // достаем сырой баннер из первого запроса
        Map<String, Map> logEntryReq1 = logs.get(resp.getUuid()[0]);
        Map<String, Map> requestReq1 = logEntryReq1 != null ?
                logEntryReq1.get(ClientDataStdLogEntry.REQUEST) : null;
        Map<String, Map> ordersReq1 = requestReq1 != null ?
                requestReq1.get(ClientDataStdRequest.ORDERS) : null;
        Map<String, Map> orderReq1 = ordersReq1 != null ?
                ordersReq1.get("" + cid) : null;
        Map<String, Map> contextsReq1 = orderReq1 != null ?
                orderReq1.get(Campaign.CONTEXTS) : null;
        Map<String, Map> contextReq1 = contextsReq1 != null ?
                contextsReq1.get("" + pid) : null;
        Map<String, Map> bannersReq1 = contextReq1 != null ?
                contextReq1.get(Context.BANNERS) : null;
        picReq1 = bannersReq1 != null ?
                bannersReq1.get("" + imageId) : null;

        // достаем сырой баннер из второго запроса
        Map<String, Map> logEntryReq2 = logs.get(resp.getUuid()[0]);
        Map<String, Map> requestReq2 = logEntryReq2 != null ?
                logEntryReq2.get(ClientDataStdLogEntry.REQUEST) : null;
        Map<String, Map> ordersReq2 = requestReq2 != null ?
                requestReq2.get(ClientDataStdRequest.ORDERS) : null;
        Map<String, Map> orderReq2 = ordersReq2 != null ?
                ordersReq2.get("" + cid) : null;
        Map<String, Map> contextsReq2 = orderReq2 != null ?
                orderReq2.get(Campaign.CONTEXTS) : null;
        Map<String, Map> contextReq2 = contextsReq2 != null ?
                contextsReq2.get("" + pid) : null;
        Map<String, Map> bannersReq2 = contextReq2 != null ?
                contextReq2.get(Context.BANNERS) : null;
        picReq2 = bannersReq2 != null ?
                bannersReq2.get("" + imageId) : null;
    }

    @Test
    @Title("Отправка в БК параметра Age (возрастная метка) " +
            "для картинки дин. баннера в первом запросе (наличие)")
    public void testAgeReq1Existence() {
        assumeThat("в первом запросе к БК присутствует баннер", picReq1, notNullValue());
        assertThat("в БК отправлен параметр Age", picReq1.keySet().contains(PARAM_AGE), is(true));
    }

    @Test
    @Title("Отправка в БК параметра Age (возрастная метка) " +
            "для картинки дин. баннера в первом запросе (значение)")
    public void testAgeReq1Value() {
        assumeThat("в первом запросе к БК присутствует баннер", picReq1, notNullValue());
        assertThat("значение отправленного в БК параметра Age соответствует ожидаемому",
                picReq1.get(PARAM_AGE), nullValue());
    }

    @Test
    @Title("Отправка в БК параметра Age (возрастная метка) " +
            "для картинки дин. баннера во втором запросе (наличие)")
    public void testAgeReq2Existence() {
        assumeThat("во втором запросе к БК присутствует баннер", picReq2, notNullValue());
        assertThat("в БК отправлен параметр Age", picReq2.keySet().contains(PARAM_AGE), is(true));
    }

    @Test
    @Title("Отправка в БК параметра Age (возрастная метка) " +
            "для картинки дин. баннера во втором запросе (значение)")
    public void testAgeReq2Value() {
        assumeThat("во втором запросе к БК присутствует баннер", picReq2, notNullValue());
        assertThat("значение отправленного в БК параметра Age соответствует ожидаемому",
                picReq2.get(PARAM_AGE), nullValue());
    }
}
