package ru.yandex.autotests.directintapi.bstransport.main.group.actions.creation.queue;

import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.nullValue;
import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Транспорт: проверка постановки в очередь ppc.bs_export_queue " +
        "новых групп в составе новой кампании")
@Stories(StoriesNames.GROUP_ACTION_CREATION)
@Features({FeatureNames.GROUPS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class AddingToBsQueueNewGroupInNewCampaignTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }

    @Test
    @Title("Добавление в очередь новой группы в новой кампании " +
            "(с принятыми фразой и баннером)")
    public void testAddingToBsQueueForGroupInNewCampaignWithAcceptedPhraseAndBanner() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        RunBsTransportScriptResponse response = api.userSteps.transportSteps().runBsClientDataScript(shard, cid);

        Map campaign = api.userSteps.transportSteps().getRawClientDataLogRequestForCampaign(response, cid);
        assertThat("Ожидаем, что в БК может быть отправлена кампания", campaign, notNullValue());

        Map context = api.userSteps.transportSteps().getRawClientDataLogRequestForContext(response, cid, pid);
        assertThat("Ожидаем, что в БК может быть отправлена группа", context, notNullValue());

        Map banner = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(response, cid, pid, bid);
        assertThat("Ожидаем, что в БК может быть отправлен баннер", banner, notNullValue());

        Map phrase = api.userSteps.transportSteps().getRawClientDataLogRequestForKeyword(response, cid, pid);
        assertThat("Ожидаем, что в БК может быть отправлена фраза", phrase, notNullValue());
    }

    @Test
    @Title("Добавление в очередь новой группы в новой кампании " +
            "(без принятых баннеров)")
    public void testAddingToBsQueueForGroupInNewCampaignWithNoAcceptedBanners() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        RunBsTransportScriptResponse response = api.userSteps.transportSteps().runBsClientDataScript(shard, cid);

        Map campaign = api.userSteps.transportSteps().getRawClientDataLogRequestForCampaign(response, cid);
        assertThat("Ожидаем, что в БК может быть отправлена кампания", campaign, notNullValue());
        Map context = api.userSteps.transportSteps().getRawClientDataLogRequestForContext(response, cid,
                pid);
        assertThat("Ожидаем, что в БК не отправлена группа", context, nullValue());
        Map banner = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(response, cid,
                pid, bid);
        assertThat("Ожидаем, что в БК не отправлен баннер", banner, nullValue());
    }

    @Test
    @Title("Добавление в очередь новой группы в новой кампании " +
            "(без принятых фраз)")
    public void testAddingToBsQueueForNewGroupInNewCampaignWithNoAcceptedPhrases() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        RunBsTransportScriptResponse response = api.userSteps.transportSteps().runBsClientDataScript(shard, cid);

        Map campaign = api.userSteps.transportSteps().getRawClientDataLogRequestForCampaign(response, cid);
        assertThat("Ожидаем, что в БК может быть отправлена кампания", campaign, notNullValue());

        Map context = api.userSteps.transportSteps().getRawClientDataLogRequestForContext(response, cid, pid);
        assertThat("Ожидаем, что в БК может быть отправлена группа", context, notNullValue());

        Map banner = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(response, cid, pid, bid);
        assertThat("Ожидаем, что в БК может быть отправлен баннер", banner, notNullValue());
    }

    @Test
    @Title("Добавление в очередь нескольких новых групп в новой кампании")
    public void testAddingToBsQueueForNewGroupsInNewCampaign() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pidOfFirstGroup = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bidInFirstGroup = api.userSteps.adsSteps().addDefaultTextAd(pidOfFirstGroup);
        Long bidInFirstGroupElse = api.userSteps.adsSteps().addDefaultTextAd(pidOfFirstGroup);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pidOfFirstGroup);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pidOfFirstGroup);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidInFirstGroup);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidInFirstGroupElse);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        Long pidOfSecondGroup = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bidInSecondGroup = api.userSteps.adsSteps().addDefaultTextAd(pidOfSecondGroup);
        Long keywordIdElse = api.userSteps.keywordsSteps().addDefaultKeyword(pidOfSecondGroup);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pidOfSecondGroup);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidInSecondGroup);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordIdElse);


        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        RunBsTransportScriptResponse response = api.userSteps.transportSteps().runBsClientDataScript(shard, cid);

        Map campaign = api.userSteps.transportSteps().getRawClientDataLogRequestForCampaign(response, cid);
        assertThat("Ожидаем, что в БК может быть отправлена кампания", campaign, notNullValue());

        Map contextOfFirstGroup = api.userSteps.transportSteps().getRawClientDataLogRequestForContext(response, cid,
                pidOfFirstGroup);
        assertThat("Ожидаем, что в БК может быть отправлена первая группа", contextOfFirstGroup, notNullValue());

        Map bannerInFirstGroup = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(response, cid,
                pidOfFirstGroup, bidInFirstGroup);
        assertThat("Ожидаем, что в БК может быть отправлен баннер из первой группы", bannerInFirstGroup,
                notNullValue());

        Map bannerInFirstGroupElse = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(response, cid
                , pidOfFirstGroup, bidInFirstGroupElse);
        assertThat("Ожидаем, что в БК может быть отправлен другой баннер из первой группы", bannerInFirstGroupElse,
                notNullValue());

        Map phraseOfFirstGroup = api.userSteps.transportSteps().getRawClientDataLogRequestForKeyword(response, cid,
                pidOfFirstGroup);
        assertThat("Ожидаем, что в БК может быть отправлена фраза из первой группы", phraseOfFirstGroup,
                notNullValue());

        Map contextOfSecondGroup = api.userSteps.transportSteps().getRawClientDataLogRequestForContext(response, cid,
                pidOfSecondGroup);
        assertThat("Ожидаем, что в БК может быть отправлена вторая группа", contextOfSecondGroup, notNullValue());

        Map bannerOfSecondGroup = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(response, cid,
                pidOfSecondGroup, bidInSecondGroup);
        assertThat("Ожидаем, что в БК может быть отправлен баннер из второй группы", bannerOfSecondGroup,
                notNullValue());

        Map phraseOfSecondGroup = api.userSteps.transportSteps().getRawClientDataLogRequestForKeyword(response,
                cid, pidOfSecondGroup);
        assertThat("Ожидаем, что в БК может быть отправлена фраза из второй группы", phraseOfSecondGroup,
                notNullValue());
    }
}
