package ru.yandex.autotests.directintapi.bstransport.main.group.actions.creation.queue;

import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BsExportQueueRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.nullValue;
import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.directapi.darkside.model.Status.NO;
import static ru.yandex.autotests.directapi.darkside.model.Status.YES;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Транспорт: проверка постановки в очередь ppc.bs_export_queue " +
        "новых групп в составе синхронизированной кампании")
@Stories(StoriesNames.GROUP_ACTION_CREATION)
@Features({FeatureNames.GROUPS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class AddingToBsQueueNewGroupInSyncedCampaignTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }

    @Test
    @Title("Добавление в очередь кампании с новой группой (кампания синхронизирована ранее) " +
            "(с принятыми фразой и баннером)")
    public void testAddingToBsQueueForNewGroupInSyncedCampaignWithAcceptedPhraseAndBanner() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Long newPid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long newBid = api.userSteps.adsSteps().addDefaultTextAd(newPid);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(newPid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(newPid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(newBid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        BsExportQueueRecord campInExportQueue =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).transportSteps().getBsExportQueueRecord(cid);
        RunBsTransportScriptResponse response =
                api.userSteps.getDarkSideSteps().getTransportSteps().runBsClientDataScript(shard, cid);
        check(response, cid, newBid, newPid);
    }

    @Test
    @Title("Добавление в очередь новой группы в синхронизированной кампании " +
            "(без принятых баннеров)")
    public void testAddingToBsQueueForNewGroupInSyncedCampaignWithNoAcceptedBanners() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Long newPid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(cid);
        Long newBid = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withVCardId(vCardId)));
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(newPid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(newPid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        RunBsTransportScriptResponse response =
                api.userSteps.getDarkSideSteps().getTransportSteps().runBsClientDataScript(shard, cid);
        assertThat("при попытке отправки в БК ничего не отправилось для синхронизированной кампании с принятой новой " +
                "группой без принятых баннеров", response, nullValue());
    }

    @Test
    @Title("Добавление в очередь кампании с новой группой (кампания синхронизирована ранее) " +
            "(без принятых фраз)")
    public void testAddingToBsQueueForNewGroupInSyncedCampaignWithNoAcceptedPhrases() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Long newPid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(cid);
        Long newBid = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(newPid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withVCardId(vCardId)));
        api.userSteps.keywordsSteps().addDefaultKeyword(newPid);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().makeBannerFullyModerated(newBid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(newPid);

        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        RunBsTransportScriptResponse response =
                api.userSteps.getDarkSideSteps().getTransportSteps().runBsClientDataScript(shard, cid);
        assertThat("при попытке отправки в БК ничего не отправилось для кампании с новой группой " +
                "(кампаниясинхронизирована ранее) (без принятых фраз)", response, nullValue());
    }

    @Test
    @Title("Добавление в очередь нескольких новых групп в синхронизированной кампании")
    public void testAddingToBsQueueForNewGroupsInSyncedCampaign() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Long pidOfFirstGroup = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(cid);
        Long bidInFirstGroup1 = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pidOfFirstGroup)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withVCardId(vCardId)));
        Long bidInFirstGroup2 = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pidOfFirstGroup)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withVCardId(vCardId)));
        Long keywordIdFirstGroup = api.userSteps.keywordsSteps().addDefaultKeyword(pidOfFirstGroup);


        Long pidOfSecondGroup = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bidInSecondGroup = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pidOfSecondGroup)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withVCardId(vCardId)));
        Long keywordIdSecondGroup1 = api.userSteps.keywordsSteps().addDefaultKeyword(pidOfSecondGroup);
        Long keywordIdSecondGroup2 = api.userSteps.keywordsSteps().addDefaultKeyword(pidOfSecondGroup);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().makeBannerFullyModerated(bidInFirstGroup1);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().makeBannerFullyModerated(bidInFirstGroup2);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pidOfFirstGroup);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordIdFirstGroup);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().makeBannerFullyModerated(bidInSecondGroup);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pidOfSecondGroup);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordIdSecondGroup1);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordIdSecondGroup2);

        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);
        RunBsTransportScriptResponse response =
                api.userSteps.getDarkSideSteps().getTransportSteps().runBsClientDataScript(shard, cid);
        check(response, cid, bidInFirstGroup1, pidOfFirstGroup);
        check(response, cid, bidInFirstGroup2, pidOfFirstGroup);
        check(response, cid, bidInSecondGroup, pidOfSecondGroup);
    }

    @Test
    @Title("Добавление в очередь новой группы в синхронизированной кампании" +
            "(присутствует отклоненная новая группа)")
    public void testAddingToBsQueueForNewGroupInSyncedCampaignWithDeclinedGroups() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Long pidOfFirstGroup = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(cid);
        Long bidInFirstGroup = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pidOfFirstGroup)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withVCardId(vCardId)));
        Long keywordIdFirstGroup = api.userSteps.keywordsSteps().addDefaultKeyword(pidOfFirstGroup);


        Long pidOfSecondGroup = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bidInSecondGroup = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pidOfSecondGroup)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withVCardId(vCardId)));
        Long keywordIdSecondGroup = api.userSteps.keywordsSteps().addDefaultKeyword(pidOfSecondGroup);

        // группу отклоняем, а все ее подобъекты принимаем
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().makeBannerFullyModerated(bidInFirstGroup);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordIdFirstGroup);
        api.userSteps.groupFakeSteps().setStatusModerate(pidOfFirstGroup, YES);
        api.userSteps.groupFakeSteps().setStatusPostModerate(pidOfFirstGroup, NO);

        // принимаем группу вместе со всеми подобъектами
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().makeBannerFullyModerated(bidInSecondGroup);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordIdSecondGroup);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pidOfSecondGroup);

        api.userSteps.getDarkSideSteps().getTransportSteps().runBsExportMasterScript(shard, cid);

        RunBsTransportScriptResponse response =
                api.userSteps.getDarkSideSteps().getTransportSteps().runBsClientDataScript(shard, cid);
        check(response, cid, bidInSecondGroup, pidOfSecondGroup);
    }

    private void check(RunBsTransportScriptResponse response, Long cid, Long bid, Long pid) {
        Map context = api.userSteps.transportSteps().getRawClientDataLogRequestForContext(response, cid,
                pid);
        assertThat("Ожидаем, что в БК может быть отправлена группа", context, notNullValue());
        Map banner = api.userSteps.transportSteps().getRawClientDataLogRequestForBanner(response, cid,
                pid, bid);
        assertThat("Ожидаем, что в БК может быть отправлен баннер", banner, notNullValue());
        Map phrase = api.userSteps.transportSteps().getRawClientDataLogRequestForKeyword(response, cid,
                pid);
        assertThat("Ожидаем, что в БК может быть отправлена фраза", phrase.values(), notNullValue());
    }
}
