package ru.yandex.autotests.directintapi.bstransport.main.group.actions.creation.transmit;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК нескольких новых групп " +
        "с принятыми баннерами и фразами в составе новой кампании (1 запрос)")
@Stories(StoriesNames.GROUP_ACTION_CREATION)
@Features({FeatureNames.GROUPS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewFilledGroupsInNewCampaignReq1Test
        extends BsTransportOfNewFilledGroupsInNewCampaignBaseTest {

    @Test
    @Title("Отправка в БК нескольких новых групп в новой кампании - " +
            "проверка объекта Кампания")
    public void testTransportOfCampaignObjReq1ForNewGroupsInNewCampaignWithAcceptedPhrasesAndAcceptedBanners() {
        assertThat("отправленные в БК данные новой кампании соответствуют ожидаемым",
                campaignReq1, helpSteps.campaignReq1Matcher(cid, shard));
    }


    @Test
    @Title("Отправка в БК нескольких новых групп в новой кампании - " +
            "проверка объекта Контекст 1")
    public void testTransportOfContext1ObjReq1ForNewGroupsInNewCampaignWithAcceptedPhrasesAndAcceptedBanners() {
        Context expectedContext1 = helpSteps.buildExpectedContextObjFromDb(pid1, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные новой группы соответствуют ожидаемым",
                context1Req1, beanEquals(expectedContext1));
    }

    @Test
    @Title("Отправка в БК нескольких новых групп в новой кампании - " +
            "проверка объекта Фраза (в Контексте 1)")
    public void testTransportOfPhrase1ObjReq1ForNewGroupsInNewCampaignWithAcceptedPhrasesAndAcceptedBanners() {
        Phrase expectedPhrase1 = helpSteps.buildExpectedPhraseObjFromDb(bidsId1, shard, UpdateInfo.UPDATE);
        expectedPhrase1.setId(null); // PhraseID может успеть записаться в базу, не проверяем его
        assertThat("отправленные в БК данные новой фразы соответствуют ожидаемым",
                phrase1Req1, beanEquals(expectedPhrase1));
    }

    @Test
    @Title("Отправка в БК нескольких новых групп в новой кампании - " +
            "проверка объекта Баннер (в Контексте 1)")
    public void testTransportOfBanner1ObjReq1ForNewGroupsInNewCampaignWithAcceptedPhrasesAndAcceptedBanners() {
        Banner expectedBanner1 = helpSteps.buildExpectedNewBannerObjFromDb(bid1, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                banner1Req1, beanEquals(expectedBanner1));
    }


    @Test
    @Title("Отправка в БК нескольких новых групп в новой кампании - " +
            "проверка объекта Контекст 2")
    public void testTransportOfContext2ObjReq1ForNewGroupsInNewCampaignWithAcceptedPhrasesAndAcceptedBanners() {
        Context expectedContext2 = helpSteps.buildExpectedContextObjFromDb(pid2, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные новой группы соответствуют ожидаемым",
                context2Req1, beanEquals(expectedContext2));
    }

    @Test
    @Title("Отправка в БК нескольких новых групп в новой кампании - " +
            "проверка объекта Фраза (в Контексте 2)")
    public void testTransportOfPhrase2ObjReq1ForNewGroupsInNewCampaignWithAcceptedPhrasesAndAcceptedBanners() {
        Phrase expectedPhrase2 = helpSteps.buildExpectedPhraseObjFromDb(bidsId2, shard, UpdateInfo.UPDATE);
        expectedPhrase2.setId(null); // PhraseID может успеть записаться в базу, не проверяем его
        assertThat("отправленные в БК данные новой фразы соответствуют ожидаемым",
                phrase2Req1, beanEquals(expectedPhrase2));
    }

    @Test
    @Title("Отправка в БК нескольких новых групп в новой кампании - " +
            "проверка объекта Баннер (в Контексте 2)")
    public void testTransportOfBanner2ObjReq1ForNewGroupsInNewCampaignWithAcceptedPhrasesAndAcceptedBanners() {
        Banner expectedBanner2 = helpSteps.buildExpectedNewBannerObjFromDb(bid2, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                banner2Req1, beanEquals(expectedBanner2));
    }
}
