package ru.yandex.autotests.directintapi.bstransport.main.group.actions.creation.transmit;
import ru.yandex.qatools.Tag;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;

import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static org.hamcrest.Matchers.*;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК нескольких новых групп " +
        "с принятыми баннерами и фразами в составе новой кампании (2 запрос)")
@Stories(StoriesNames.GROUP_ACTION_CREATION)
@Features({FeatureNames.GROUPS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewFilledGroupsInNewCampaignReq2Test
        extends BsTransportOfNewFilledGroupsInNewCampaignBaseTest {

    @Test
    @Title("Отправка в БК нескольких новых групп в новой кампании (2 запрос) - " +
            "проверка объекта Кампания")
    public void testTransportOfCampaignObjReq2ForNewGroupsInNewCampaignWithAcceptedPhrasesAndAcceptedBanners() {
        String orderId = campaignResp1.getId();
        assumeThat("БК вернуло OrderId", orderId, not(isEmptyOrNullString()));

        Campaign expectedCampaign = helpSteps.buildExpectedCampaignObjFromDb(cid, shard, UpdateInfo.UPDATE);
        expectedCampaign.setId(orderId);
        expectedCampaign.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные новой кампании соответствуют ожидаемым",
                campaignReq2, beanEquals(expectedCampaign));
    }


    @Test
    @Title("Отправка в БК нескольких новых групп в новой кампании (2 запрос) - " +
            "проверка объекта Контекст 1")
    public void testTransportOfContext1ObjReq2ForNewGroupsInNewCampaignWithAcceptedPhrasesAndAcceptedBanners() {
        Context expectedContext1 = helpSteps.buildExpectedContextObjFromDb(pid1, shard, UpdateInfo.SKIP);
        assertThat("отправленные в БК данные новой группы соответствуют ожидаемым",
                context1Req2, beanEquals(expectedContext1));
    }

    @Test
    @Title("Отправка в БК нескольких новых групп в новой кампании (2 запрос) - " +
            "проверка списка Фраз (в Контексте 1)")
    public void testTransportOfPhrase1ObjReq2ForNewGroupsInNewCampaignWithAcceptedPhrasesAndAcceptedBanners() {
        assertThat("в БК вторым запросом не отправлены фразы", phrases1Req2, nullValue());
    }

    @Test
    @Title("Отправка в БК нескольких новых групп в новой кампании (2 запрос) - " +
            "проверка объекта Баннер (в Контексте 1)")
    public void testTransportOfBanner1ObjReq2ForNewGroupsInNewCampaignWithAcceptedPhrasesAndAcceptedBanners() {
        String bannerId = banner1Resp1.getId();
        assumeThat("БК вернула BannerID в ответе на первый запрос",
                bannerId, not(isEmptyOrNullString()));

        Banner expectedBanner1 = helpSteps.buildExpectedBannerObjFromDb(bid1, shard, UpdateInfo.SKIP);
        expectedBanner1.setId(bannerId);
        expectedBanner1.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                banner1Req2, beanEquals(expectedBanner1));
    }


    @Test
    @Title("Отправка в БК нескольких новых групп в новой кампании (2 запрос) - " +
            "проверка объекта Контекст 2")
    public void testTransportOfContext2ObjReq2ForNewGroupsInNewCampaignWithAcceptedPhrasesAndAcceptedBanners() {
        Context expectedContext2 = helpSteps.buildExpectedContextObjFromDb(pid2, shard, UpdateInfo.SKIP);
        assertThat("отправленные в БК данные новой группы соответствуют ожидаемым",
                context2Req2, beanEquals(expectedContext2));
    }

    @Test
    @Title("Отправка в БК нескольких новых групп в новой кампании (2 запрос) - " +
            "проверка списка Фраз (в Контексте 2)")
    public void testTransportOfPhrase2ObjReq2ForNewGroupsInNewCampaignWithAcceptedPhrasesAndAcceptedBanners() {
        assertThat("в БК вторым запросом не отправлены фразы", phrases2Req2, nullValue());
    }

    @Test
    @Title("Отправка в БК нескольких новых групп в новой кампании (2 запрос) - " +
            "проверка объекта Баннер (в Контексте 2)")
    public void testTransportOfBanner2ObjReq2ForNewGroupsInNewCampaignWithAcceptedPhrasesAndAcceptedBanners() {
        String bannerId = banner2Resp1.getId();
        assumeThat("БК вернула BannerID в ответе на первый запрос",
                bannerId, not(isEmptyOrNullString()));

        Banner expectedBanner2 = helpSteps.buildExpectedBannerObjFromDb(bid2, shard, UpdateInfo.SKIP);
        expectedBanner2.setId(bannerId);
        expectedBanner2.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                banner2Req2, beanEquals(expectedBanner2));
    }
}
