package ru.yandex.autotests.directintapi.bstransport.main.group.actions.creation.transmit;

import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;

import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

public class BsTransportOfNewFilledGroupsInSyncedCampaignBaseTest {

    protected static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    protected static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    protected static int shard;

    protected static Long cid;
    protected static Long bid1;
    protected static Long pid1;
    protected static Long bidsId1;
    protected static Long bid2;
    protected static Long pid2;
    protected static Long bidsId2;

    protected static Campaign campaignReq1;
    protected static Context context1Req1;
    protected static Phrase phrase1Req1;
    protected static Banner banner1Req1;
    protected static Context context2Req1;
    protected static Phrase phrase2Req1;
    protected static Banner banner2Req1;

    protected static Campaign campaignResp1;
    protected static Banner banner1Resp1;
    protected static Banner banner2Resp1;

    protected static Campaign campaignReq2;
    protected static Context context1Req2;
    protected static Collection<Phrase> phrases1Req2;
    protected static Banner banner1Req2;
    protected static Context context2Req2;
    protected static Collection<Phrase> phrases2Req2;
    protected static Banner banner2Req2;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        pid1 = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid1 = api.userSteps.adsSteps().addDefaultTextAd(pid1);
        bidsId1 = api.userSteps.keywordsSteps().addDefaultKeyword(pid1);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid1);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid1);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId1);

        pid2 = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid2 = api.userSteps.adsSteps().addDefaultTextAd(pid2);
        bidsId2 = api.userSteps.keywordsSteps().addDefaultKeyword(pid2);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid2);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid2);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidsId2);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);
        campaignReq1 = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        context1Req1 = campaignReq1 != null ? campaignReq1.getContext(pid1) : null;
        phrase1Req1 = context1Req1 != null ? context1Req1.getPhrase(bidsId1) : null;
        banner1Req1 = context1Req1 != null ? context1Req1.getBanner(bid1) : null;
        context2Req1 = campaignReq1 != null ? campaignReq1.getContext(pid2) : null;
        phrase2Req1 = context2Req1 != null ? context2Req1.getPhrase(bidsId2) : null;
        banner2Req1 = context2Req1 != null ? context2Req1.getBanner(bid2) : null;

        campaignResp1 = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataResponseCampaign(resp, 0, cid);
        Context context1Resp1 = campaignResp1 != null ? campaignResp1.getContext(pid1) : null;
        banner1Resp1 = context1Resp1 != null ? context1Resp1.getBanner(bid1) : null;
        Context context2Resp1 = campaignResp1 != null ? campaignResp1.getContext(pid2) : null;
        banner2Resp1 = context2Resp1 != null ? context2Resp1.getBanner(bid2) : null;

        campaignReq2 = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 1, cid);
        context1Req2 = campaignReq2 != null ? campaignReq2.getContext(pid1) : null;
        phrases1Req2 = context1Req2 != null &&
                context1Req2.getPhrases() != null &&
                context1Req2.getPhrases().values().size() > 0 ?
                context1Req2.getPhrases().values() : null;
        banner1Req2 = context1Req2 != null ? context1Req2.getBanner(bid1) : null;
        context2Req2 = campaignReq2 != null ? campaignReq2.getContext(pid2) : null;
        phrases2Req2 = context2Req2 != null &&
                context2Req2.getPhrases() != null &&
                context2Req2.getPhrases().values().size() > 0 ?
                context2Req2.getPhrases().values() : null;
        banner2Req2 = context2Req2 != null ? context2Req2.getBanner(bid2) : null;
    }
}
