package ru.yandex.autotests.directintapi.bstransport.main.group.actions.creation.transmit;

import java.util.Map;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directapi.darkside.model.Status.NEW;
import static ru.yandex.autotests.directapi.darkside.model.Status.NO;
import static ru.yandex.autotests.directapi.darkside.model.Status.YES;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК новой группы " +
        "без принятых баннеров в составе новой кампании")
@Stories(StoriesNames.GROUP_ACTION_CREATION)
@Features({FeatureNames.GROUPS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewGroupInNewCampaignWithAcceptedPhrasesAndNoAcceptedBannersTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private static Long cid;

    private static Campaign campaignReq1;

    private static Map<String, Context> contextsReq1;

    private static Map<String, Context> contextsReq2;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long sitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(3);
        Long bid1 = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withSitelinkSetId(sitelinkSetId)));
        Long bid2 = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusModerate(bid1, YES);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusSitelinksModerate(bid1, NEW);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusPostModerate(bid1, YES);

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusModerate(bid2, YES);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusPostModerate(bid2, NO);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        campaignReq1 = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        contextsReq1 = campaignReq1 != null &&
                campaignReq1.getContexts() != null
                && campaignReq1.getContexts().size() > 0 ?
                campaignReq1.getContexts() : null;

        Campaign campaignReq2 = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 1, cid);
        contextsReq2 = campaignReq2 != null &&
                campaignReq2.getContexts() != null &&
                campaignReq2.getContexts().size() > 0 ?
                campaignReq2.getContexts() : null;
    }

    @Test
    @Title("Отправка в БК новой группы в новой кампании без принятых баннеров (1 итерация) - " +
            "проверка объекта Кампания")
    public void testTransportOfCampaignObjReq1ForNewGroupInNewCampaignWithAcceptedPhrasesAndNoAcceptedBanners() {
        assertThat("отправленные в БК данные новой кампании соответствуют ожидаемым",
                campaignReq1, helpSteps.campaignReq1Matcher(cid, shard));
    }

    @Test
    @Title("Отправка в БК новой группы в новой кампании без принятых баннеров (1 итерация) - " +
            "проверка списка Контекстов")
    public void testTransportOfContextListReq1ForNewGroupInNewCampaignWithAcceptedPhrasesAndNoAcceptedBanners() {
        assertThat("в БК отправлен пустой список групп", contextsReq1, nullValue());
    }

    @Test
    @Title("Отправка в БК новой группы в новой кампании без принятых баннеров (1 итерация) - " +
            "проверка списка Контекстов")
    public void testTransportOfContextListReq2OfReqNumForNewGroupInNewCampaignWithAcceptedPhrasesAndNoAcceptedBanners() {
        assertThat("в БК отправлен пустой список групп", contextsReq2, nullValue());
    }
}
