package ru.yandex.autotests.directintapi.bstransport.main.group.actions.creation.transmit;

import java.util.List;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListGetItem;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Title("Транспорт: проверка отправки в БК группы, " +
        "со всеми выключенными фразами и недоступным ретаргетингом")
@Stories(StoriesNames.GROUP_ACTION_CREATION)
@Feature(ApiFeatures.NOT_REGRESSION_YET)
@Issue("https://st.yandex-team.ru/DIRECT-39912")
public class BsTransportOfNewGroupWithAllPhrasesSuspendedAndRetargetingTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;
    private Campaign campaign;
    private long goalId = 0;
    private static List<Long> retIds;
    private Long cid;
    private Long pid;
    private Long pidWithRetargeting;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        retIds = helpSteps.addRetargetingListsForUserIfNotExists(LOGIN);
    }

    @Before
    public void prepare() {
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        pidWithRetargeting = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bidWithSuspendedPhrases = api.userSteps.adsSteps().addDefaultTextAd(pidWithRetargeting);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pidWithRetargeting);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pidWithRetargeting);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidWithSuspendedPhrases);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.audienceTargetsSteps().addWithRetargetingList(LOGIN, pidWithRetargeting, retIds.get(0));

        api.userSteps.getDirectJooqDbSteps().useShard(shard).bidsSteps().setSuspended(keywordId);
    }

    @Test
    @Title("Отправка в БК группы, со всеми выключенными фразами и недоступным ретаргетингом")
    public void testTransportOfBannerWithAllPhrasesSuspendedAndInaccessibleRetargeting() {
        RetargetingListGetItem retargetingListGetItem
                = api.userSteps.retargetingListsSteps().get(retIds.get(0)).get(0);
        goalId = retargetingListGetItem.getRules().get(0).getArguments().get(0).getExternalId();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).retargetingGoalsSteps()
                .setIsAccessible(retIds.get(0), goalId, 0);
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        assumeThat("в БК отправлена новая группа с включенными фразами", context, notNullValue());
        assertThat("группа с выключенными фразами и недоступным ретаргетингом не отправилась в БК"
                , campaign.getContexts().size(), equalTo(1));
    }

    @Test
    @Title("Отправка в БК группы, со всеми выключенными фразами и недоступным ретаргетингом, переотправка")
    public void testTransportOfSyncedBannerWithAllPhrasesSuspendedAndInaccessibleRetargetind() {
        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        assumeThat("в БК отправлена новая группа с включенными фразами", context, notNullValue());
        context = campaign != null ? campaign.getContext(pidWithRetargeting) : null;
        assumeThat("в БК отправлена новая группа с выключенными фразами и доступным ретаргетингом"
                , context, notNullValue());
        RetargetingListGetItem retargetingListGetItem
                = api.userSteps.retargetingListsSteps().get(retIds.get(0)).get(0);
        goalId = retargetingListGetItem.getRules().get(0).getArguments().get(0).getExternalId();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).retargetingGoalsSteps()
                .setIsAccessible(retIds.get(0), goalId, 0);
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pidWithRetargeting, Status.NO);
        resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pidWithRetargeting) : null;
        assumeThat("в БК отправлена группа с выключенными фразами и недоступным ретаргетингом"
                , context, notNullValue());
        assertThat("группа с выключенными фразами и недоступным ретаргетингом не отправилась в БК"
                , context.getGoalContexts().size(), equalTo(0));
    }

    @After
    public void after() {
        if (goalId != 0) {
            api.userSteps.getDirectJooqDbSteps().useShard(shard).retargetingGoalsSteps()
                    .setIsAccessible(retIds.get(0), goalId, 1);
        }
    }


}
