package ru.yandex.autotests.directintapi.bstransport.main.group.actions.creation.transmit;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Title("Транспорт: проверка отправки в БК группы, " +
        "со всеми выключенными фразами")
@Stories(StoriesNames.GROUP_ACTION_CREATION)
@Features({FeatureNames.GROUPS, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/DIRECT-39912")
public class BsTransportOfNewGroupWithAllPhrasesSuspendedTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;
    private Campaign campaign;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    public void prepare() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        Long pidWithSuspendedPhrases = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bidWithSuspendedPhrases = api.userSteps.adsSteps().addDefaultTextAd(pidWithSuspendedPhrases);
        Long suspendedPhrase = api.userSteps.keywordsSteps().addDefaultKeyword(pidWithSuspendedPhrases);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pidWithSuspendedPhrases);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidWithSuspendedPhrases);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(suspendedPhrase);

        api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN).bidsSteps().setSuspended(suspendedPhrase);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        assumeThat("в БК отправлена новая группа с включенными фразами", context, notNullValue());

    }

    @Test
    @Title("Отправка в БК группы, со всеми выключенными фразами")
    public void testTransportOfBannerWithAllPhrasesSuspended() {
        assertThat("группа с выключенными фразами не отправилась в БК", campaign.getContexts().size(), equalTo(1));
    }
}
