package ru.yandex.autotests.directintapi.bstransport.main.group.actions.creation.transmit;

import java.util.HashMap;
import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by n-boy on 06.12.16.
 * https://st.yandex-team.ru/TESTIRT-8623
 */
@Aqua.Test
@Title("Транспорт: проверка отправки в БК старой группы " +
        "без условий показа (фраз, условий ретаргетинга и т.п.)")
@Stories(StoriesNames.GROUP_ACTION_EDITION)
@Features({FeatureNames.GROUPS, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/DIRECT-54263")
public class BsTransportOfSyncedGroupWithoutShowConditionsTest {
    protected static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static Context context;
    private static Context contextWithRetargeting;
    private static Long bid;
    private static Long bidWithRetargeting;
    private static Banner expectedSyncedBanner;

    @BeforeClass
    public static void beforeClass() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);

        expectedSyncedBanner = new Banner();
        expectedSyncedBanner.setStop(0);
        expectedSyncedBanner.setUpdateInfo(0);

        List<Long> retIds = helpSteps.addRetargetingListsForUserIfNotExists(login);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        Long pidWithRetargeting = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bidWithRetargeting = api.userSteps.adsSteps().addDefaultTextAd(pidWithRetargeting);
        Long audienceTargetId =
                api.userSteps.audienceTargetsSteps().addWithRetargetingList(login, pidWithRetargeting, retIds.get(0));

        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pidWithRetargeting);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bidWithRetargeting);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("в БК отправлена кампания (первая итерация)", campaign, notNullValue());

        api.userSteps.keywordsSteps().keywordsDelete(login, keywordId);
        api.userSteps.audienceTargetsSteps().delete(login, audienceTargetId);

        resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("в БК отправлена кампания", campaign, notNullValue());

        context = campaign.getContext(pid);
        contextWithRetargeting = campaign.getContext(pidWithRetargeting);
    }

    @Test
    @Title("Отправка в БК ранее синхронизированной группы, после удаления всех фраз")
    public void testTransportOfSyncedGroupWithDeletedAllPhrases() {
        assertThat("группа после удаления всех фраз успешно ушла в БК", context, notNullValue());

    }

    @Test
    @Title("Отправка в БК ранее синхронизированной группы, после удаления всех фраз, проверяем UpdateInfo")
    public void testTransportOfSyncedGroupWithDeletedAllPhrasesCheckUpdateInfo() {
        assertThat("группа после удаления всех фраз успешно ушла в БК, с UpdateInfo=1",
                context != null ? context.getUpdateInfo() : null, equalTo(1));

    }

    @Test
    @Title("Отправка в БК ранее синхронизированной группы, после удаления всех фраз, проверяем поля с условиями показа")
    public void testTransportOfSyncedGroupWithDeletedAllPhrasesCheckPhrases() {
        checkEmptyShowConditionsIsSent(context);
    }

    @Test
    @Title("Отправка в БК ранее синхронизированной группы, после удаления всех фраз, проверяем BANNER")
    public void testTransportOfSyncedGroupWithDeletedAllPhrasesCheckBanner() {
        Banner banner = context != null ? context.getBanner(bid) : null;
        assumeThat("после удаления всех фраз, синхронизированный ранее баннер успешно ушел в БК",
                banner, notNullValue());
        assertThat("после удаления всех фраз, синхронизированный ранее баннер успешно ушел в БК с UpdateInfo=0, Stop=0",
                banner, beanDiffer(expectedSyncedBanner).useCompareStrategy(
                        DefaultCompareStrategies.onlyExpectedFields()));
    }

    @Test
    @Title("Отправка в БК ранее синхронизированной группы, после удаления всех условий ретаргетинга")
    public void testTransportOfSyncedGroupWithDeletedAllRetargetings() {
        assertThat("группа после удаления всех условий ретаргетинга успешно ушла в БК", contextWithRetargeting,
                notNullValue());

    }

    @Test
    @Title("Отправка в БК ранее синхронизированной группы, после удаления всех условий ретаргетинга, проверяем UpdateInfo")
    public void testTransportOfSyncedGroupWithDeletedAllRetargetingsCheckUpdateInfo() {
        assertThat("группа после удаления всех условий ретаргетинга успешно ушла в БК, с UpdateInfo=1",
                contextWithRetargeting != null ? contextWithRetargeting.getUpdateInfo() : null, equalTo(1));

    }

    @Test
    @Title("Отправка в БК ранее синхронизированной группы, после удаления всех условий ретаргетинга, проверяем поля с условиями показа")
    public void testTransportOfSyncedGroupWithDeletedAllRetargetingsCheckPhrases() {
        checkEmptyShowConditionsIsSent(contextWithRetargeting);
    }

    @Test
    @Title("Отправка в БК ранее синхронизированной группы, после удаления всех условий ретаргетинга, проверяем BANNER")
    public void testTransportOfSyncedGroupWithDeletedAllRetargetingsCheckBanner() {
        Banner banner = contextWithRetargeting != null ? contextWithRetargeting.getBanner(bidWithRetargeting) : null;
        assumeThat("после удаления всех условий ретаргетинга, синхронизированный ранее баннер, успешно ушел в БК",
                banner, notNullValue());
        assertThat(
                "после удаления всех условий ретаргетинга, синхронизированный ранее баннер успешно ушел в БК с UpdateInfo=0, Stop=0",
                banner, beanDiffer(expectedSyncedBanner).useCompareStrategy(
                        DefaultCompareStrategies.onlyExpectedFields()));
    }

    @Step("Проверяем что поля со всеми типами условий показа отправились, и списки условий - пустые")
    private void checkEmptyShowConditionsIsSent(Context context) {
        Context expectedContext = new Context();
        expectedContext.setPhrases(new HashMap<>());
        expectedContext.setGoalContexts(new HashMap<>());
        expectedContext.setDynamics(new HashMap<>());
        expectedContext.setFilters(new HashMap<>());

        assertThat("группа отправлена с полями для всех типов условий показа, при этом списки условий пустые",
                context, beanDiffer(expectedContext).useCompareStrategy(
                        DefaultCompareStrategies.onlyExpectedFields()));
    }

}
