package ru.yandex.autotests.directintapi.bstransport.main.group.actions.creation.transmit;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Title("Транспорт: проверка отправки в БК старой группы после её отклонения")
@Stories(StoriesNames.GROUP_ACTION_EDITION)
@Features({FeatureNames.GROUPS, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfSyncedRejectedGroupTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static final ApiSteps API = new ApiSteps().as(LOGIN);

    @ClassRule
    public static final SemaphoreRule SEMAPHORE = Semaphore.getSemaphore();

    public static final int SHARD = API.userSteps.clientFakeSteps().getUserShard(LOGIN);

    private Long cid;
    private long pid;
    private long keywordId;

    @Before
    public void before() {
        API.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        cid = API.userSteps.campaignSteps().addDefaultTextCampaign();
        API.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        pid = API.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = API.userSteps.adsSteps().addDefaultTextAd(pid);
        keywordId = API.userSteps.keywordsSteps().addDefaultKeyword(pid);
        API.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        API.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        API.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        RunBsTransportScriptResponse resp =
                API.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(SHARD, cid);

        Campaign campaign =
                API.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("в БК отправлена кампания (первая итерация)", campaign, notNullValue());

        API.userSteps.groupFakeSteps().setStatusPostModerate(pid, Status.REJECTED);
        API.userSteps.groupFakeSteps().setStatusModerate(pid, Status.READY);
    }

    @Test
    public void nonemptyGroup() {
        API.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, Status.NO);
        runSecondTransportIterationAndAssert();
    }

    @Test
    public void emptyGroup() {
        API.userSteps.keywordsSteps().keywordsDelete(LOGIN, keywordId);
        runSecondTransportIterationAndAssert();
    }

    private void runSecondTransportIterationAndAssert() {
        RunBsTransportScriptResponse resp =
                API.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(SHARD, cid);
        Campaign campaign =
                API.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("в БК отправлена кампания", campaign, notNullValue());

        Context context = campaign.getContext(pid);
        assertThat("Группа отправлена в БК", context, notNullValue());
    }
}
