package ru.yandex.autotests.directintapi.bstransport.main.group.adgroupbstags;

import java.util.List;

import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.steps.DarkSideSteps;

import static org.hamcrest.Matchers.is;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

public class AdGroupBsTagsTestUtils {
    public static void getSendContextAndCheckTags(int shard,
                                                  Long cid,
                                                  Long pid,
                                                  DarkSideSteps darkSideSteps,
                                                  List<String> expectedTags) {
        RunBsTransportScriptResponse resp
                = darkSideSteps.getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = darkSideSteps
                .getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, cid);
        Context context =  campaign.getContext(pid);
        assertThat("переданы правильные Target-теги", context.getTargetTags(), is(expectedTags));
        assertThat("переданы правильные PageGroup-теги", context.getPageGroupTags(), is(expectedTags));
    }
}
