package ru.yandex.autotests.directintapi.bstransport.main.group.adgroupbstags;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.BannersRule;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.TextBannersRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupsContentPromotionContentPromotionType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsPlatform;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupBsTagsRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static java.util.Collections.singletonList;
import static ru.yandex.autotests.directintapi.bstransport.main.group.adgroupbstags.AdGroupBsTagsTestUtils.getSendContextAndCheckTags;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-99527")
@Title("Транспорт: отправка тегов на группы кампаний продвижения контента")
@Stories(StoriesNames.ADGROUP_BS_TAGS)
@Features(FeatureNames.GROUPS)
public class BsTransportOfContentPromotionAdGroupTest {
    private static final String DEFAULT_BS_TAG = "content-promotion-collection";
    private static final String LOGIN = "at-direct-test-adgroupbstags1";

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static DirectCmdRule defaultClassRule = DirectCmdRule.defaultClassRule();

    public BannersRule bannersRule = new TextBannersRule().withUlogin(LOGIN);

    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().withRules(bannersRule);

    private int shard;
    private long cid;
    private long pid;

    @Before
    public void before() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        cid = bannersRule.getCampaignId();
        pid = bannersRule.getGroupId();
        long bid = bannersRule.getBannerId();
        long keywordId = bannersRule.getCurrentGroup().getPhrases().get(0).getId();

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .campaignsSteps().setPlatform(cid, CampaignsPlatform.search);
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .campaignsSteps().setType(cid, CampaignsType.content_promotion);
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .adGroupsSteps().setType(pid, PhrasesAdgroupType.content_promotion);
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bannersSteps().setBannersBannerType(bid, BannersBannerType.content_promotion);
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .adGroupsContentPromotionSteps().addAdGroupContentPromotion(pid,
                        AdgroupsContentPromotionContentPromotionType.collection);
    }

    @Test
    public void testAdGroupWithDefaultTags() {
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .adGroupBsTagsSteps()
                .deleteAdgroupBsTags(pid);

        getSendContextAndCheckTags(shard, cid, pid,
                api.userSteps.getDarkSideSteps(), singletonList(DEFAULT_BS_TAG));
    }

    @Test
    public void testAdGroupWithCustomTags() {
        AdgroupBsTagsRecord adgroupBsTagsRecord = new AdgroupBsTagsRecord();
        adgroupBsTagsRecord.setPageGroupTagsJson("[\"custom-bstransport-tag\"]");
        adgroupBsTagsRecord.setTargetTagsJson("[\"custom-bstransport-tag\"]");
        adgroupBsTagsRecord.setPid(pid);
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .adGroupBsTagsSteps()
                .insertAdgroupBsTags(adgroupBsTagsRecord);

        getSendContextAndCheckTags(shard, cid, pid,
                api.userSteps.getDarkSideSteps(), singletonList("custom-bstransport-tag"));
    }
}
