package ru.yandex.autotests.directintapi.bstransport.main.group.adgroupbstags;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.CreativeBannerRule;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsPlatform;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PerfCreativesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.RetargetingConditionsRetargetingConditionsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupBsTagsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.RetargetingConditionsRecord;
import ru.yandex.autotests.direct.utils.campaigns.CampaignTypeEnum;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.displaycanvas.ModerationInfo;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static java.util.Collections.singletonList;
import static ru.yandex.autotests.directintapi.bstransport.main.group.adgroupbstags.AdGroupBsTagsTestUtils.getSendContextAndCheckTags;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-99527")
@Title("Транспорт: отправка тегов на группы медийки для показа на главной")
@Stories(StoriesNames.ADGROUP_BS_TAGS)
@Features(FeatureNames.GROUPS)
public class BsTransportOfCpmYndxFrontpageAdGroupTest {
    private static final String DEFAULT_BS_TAG = "portal-trusted";
    private static final String LOGIN = "at-direct-test-adgroupbstags1";

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static DirectCmdRule defaultClassRule = DirectCmdRule.defaultClassRule();

    public CreativeBannerRule bannersRule = new CreativeBannerRule(CampaignTypeEnum.TEXT).withUlogin(LOGIN);

    @Rule
    public DirectCmdRule cmdRule = DirectCmdRule.defaultRule().withRules(bannersRule);

    private int shard;
    private long cid;
    private long pid;

    private long rcId;
    private long atId;

    @After
    @Step("Утилизация тестовых данных")
    public void after() {
        api.userSteps.audienceTargetsSteps().delete(LOGIN, atId);
        api.userSteps.retargetingListsSteps().delete(LOGIN, rcId);
    }

    @Before
    public void before() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        long clientId = Long.parseLong(api.userSteps.clientFakeSteps().getClientData(LOGIN).getClientID());

        cid = bannersRule.getCampaignId();
        pid = bannersRule.getGroupId();

        long keywordId = bannersRule.getCurrentGroup().getPhrases().get(0).getId();
        long creativeId = bannersRule.getCreativeId();
        long bid = bannersRule.getBannerId();

        // api5 не позволяет создавать interest ретаргетинг без правил (в wsdl), хотя ядро считает что это валидно
        RetargetingConditionsRecord record = new RetargetingConditionsRecord()
                .setClientid(clientId)
                .setRetargetingConditionsType(RetargetingConditionsRetargetingConditionsType.interests)
                .setConditionName("test")
                .setConditionDesc("")
                .setConditionJson("[]")
                .setIsDeleted(0)
                .setProperties("");
        rcId = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .retargetingConditionSteps()
                .addRetargetingCondition(record, clientId);
        atId = api.userSteps.audienceTargetsSteps().addWithRetargetingList(LOGIN, pid, rcId);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bannersPerformanceSteps()
                .setCreativeStatusModerate(cid, pid, bid, BannersPerformanceStatusmoderate.Yes);
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .perfCreativesSteps().setModerateInfo(creativeId, new ModerationInfo().generateTestData().toString());
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .perfCreativesSteps().setStatusModerate(creativeId, PerfCreativesStatusmoderate.Yes);

        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .campaignsSteps().setPlatform(cid, CampaignsPlatform.context);
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .campaignsSteps().setType(cid, CampaignsType.cpm_yndx_frontpage);
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .campaignsSteps().setCampaignCpmYndxFrontpageAllowedTypes(cid, "frontpage");

        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .adGroupsSteps().setType(pid, PhrasesAdgroupType.cpm_yndx_frontpage);
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bannersSteps().setBannersBannerType(bid, BannersBannerType.cpm_banner);
    }

    @Test
    public void testAdGroupWithDefaultTags() {
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .adGroupBsTagsSteps()
                .deleteAdgroupBsTags(pid);

        getSendContextAndCheckTags(shard, cid, pid,
                api.userSteps.getDarkSideSteps(), singletonList(DEFAULT_BS_TAG));
    }

    @Test
    public void testAdGroupWithCustomTags() {
        AdgroupBsTagsRecord adgroupBsTagsRecord = new AdgroupBsTagsRecord();
        adgroupBsTagsRecord.setPageGroupTagsJson("[\"custom-bstransport-tag\"]");
        adgroupBsTagsRecord.setTargetTagsJson("[\"custom-bstransport-tag\"]");
        adgroupBsTagsRecord.setPid(pid);
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .adGroupBsTagsSteps()
                .insertAdgroupBsTags(adgroupBsTagsRecord);

        getSendContextAndCheckTags(shard, cid, pid,
                api.userSteps.getDarkSideSteps(), singletonList("custom-bstransport-tag"));
    }
}
