package ru.yandex.autotests.directintapi.bstransport.main.group.adgroupbstags;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupBsTagsRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static java.util.Collections.singletonList;
import static ru.yandex.autotests.directintapi.bstransport.main.group.adgroupbstags.AdGroupBsTagsTestUtils.getSendContextAndCheckTags;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-99527")
@Title("Транспорт: отправка тегов на текстовые группы")
@Stories(StoriesNames.ADGROUP_BS_TAGS)
@Features(FeatureNames.GROUPS)
public class BsTransportOfTextAdGroupTest {
    private static final String LOGIN = "at-direct-test-adgroupbstags1";

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    private int shard;
    private long cid;
    private long pid;

    @Before
    public void before() {
        shard = api.userSteps.getDirectJooqDbSteps().shardingSteps().getShardByLogin(LOGIN);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
    }

    @Test
    public void testAdGroupWithDefaultTags() {
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .adGroupBsTagsSteps()
                .deleteAdgroupBsTags(pid);
        getSendContextAndCheckTags(shard, cid, pid, api.userSteps.getDarkSideSteps(), null);
    }

    @Test
    public void testAdGroupWithCustomTags() {
        AdgroupBsTagsRecord adgroupBsTagsRecord = new AdgroupBsTagsRecord();
        adgroupBsTagsRecord.setPageGroupTagsJson("[\"custom-bstransport-tag\"]");
        adgroupBsTagsRecord.setTargetTagsJson("[\"custom-bstransport-tag\"]");
        adgroupBsTagsRecord.setPid(pid);
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .adGroupBsTagsSteps()
                .insertAdgroupBsTags(adgroupBsTagsRecord);

        getSendContextAndCheckTags(shard, cid, pid,
                api.userSteps.getDarkSideSteps(), singletonList("custom-bstransport-tag"));
    }
}
