package ru.yandex.autotests.directintapi.bstransport.main.group.hypergeo;

import java.util.List;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupAdditionalTargetingsTargetingType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupAdditionalTargetingsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.multipliers.BsAtom;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static java.util.Arrays.asList;
import static java.util.Collections.singletonList;
import static java.util.stream.Collectors.toList;
import static org.hamcrest.Matchers.empty;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupAdditionalTargetingsTargetingMode.targeting;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupAdditionalTargetingsTargetingType.auditorium_geosegments;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupAdditionalTargetingsTargetingType.visit_goals;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupAdditionalTargetingsValueJoinType.any;
import static ru.yandex.autotests.directapi.darkside.Logins.LOGIN_TRANSPORT;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-117560")
@Title("Транспорт: отправка гипер гео на группы")
@Stories(StoriesNames.ADGROUP_HYPER_GEO)
@Features(FeatureNames.GROUPS)
public class BsTransportOfHyperGeoTest {

    private static final String LOGIN = LOGIN_TRANSPORT;
    private static final Long HYPER_GEO_ID = 1L;
    private static final List<Long> GEO_SEGMENT_GOAL_IDS = asList(1L, 2L, 3L);

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(LOGIN);

    private static final DirectJooqDbSteps dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
    private static final int shard = dbSteps.getCurrentPpcShard();

    private Long campaignId;
    private Long adGroupId;
    private Long bannerId;

    @Before
    public void before() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        bannerId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);

        dbSteps.adGroupsSteps().setGeo(adGroupId, "0");
        dbSteps.hyperGeoSteps().addHyperGeoToAdGroup(adGroupId, HYPER_GEO_ID);
    }

    @Test
    public void sendAdGroupWithHyperGeo_OldVersionOfHyperGeo() {
        setAdGroupAdditionalTargeting(visit_goals);
        prepareCampaignForSend();

        RunBsTransportScriptResponse resp
                = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, campaignId);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, campaignId);

        Context context = campaign.getContext(adGroupId);

        assertThat(context.getGeo(), empty());
        assertThat(context.getTargetingExpression(),
                beanDiffer(singletonList(GEO_SEGMENT_GOAL_IDS.stream()
                        .map(goalId -> buildBsAtom(goalId, "visit-goal"))
                        .collect(toList()))));
    }

    @Test
    public void sendAdGroupWithHyperGeo_NewVersionOfHyperGeo() {
        setAdGroupAdditionalTargeting(auditorium_geosegments);
        prepareCampaignForSend();

        RunBsTransportScriptResponse resp
                = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, campaignId);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, campaignId);

        Context context = campaign.getContext(adGroupId);

        assertThat(context.getGeo(), empty());
        assertThat(context.getTargetingExpression(),
                beanDiffer(singletonList(GEO_SEGMENT_GOAL_IDS.stream()
                        .map(goalId -> buildBsAtom(goalId, "auditorium-geosegments"))
                        .collect(toList()))));
    }

    private void setAdGroupAdditionalTargeting(AdgroupAdditionalTargetingsTargetingType targetingType) {
        dbSteps.adGroupsInternalSteps().addAdGroupAdditionalTargetings(
                new AdgroupAdditionalTargetingsRecord()
                        .setPid(adGroupId)
                        .setTargetingMode(targeting)
                        .setTargetingType(targetingType)
                        .setValueJoinType(any)
                        .setValue(JsonUtils.toString(GEO_SEGMENT_GOAL_IDS)));
    }

    private void prepareCampaignForSend() {
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(campaignId);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(adGroupId);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bannerId);
    }

    private BsAtom buildBsAtom(Long goalId, String keyword) {
        return (BsAtom) new BsAtom()
                .withKeyword(keyword)
                .withOperation("match")
                .withValueString(goalId.toString());
    }
}
