package ru.yandex.autotests.directintapi.bstransport.main.group.minus_geo;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersMinusGeoType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersMinusGeoRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TestRegionsSet;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by n-boy on 08.03.17.
 * https://st.yandex-team.ru/TESTIRT-11106
 */

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-63267")
@Title("Транспорт: применение минус-регионов, для одиночного, нового баннера")
@Stories(StoriesNames.MINUS_GEO)
@Features(FeatureNames.GROUPS)
public class BsTransportOfMinusGeoForTextNewBannerTest {
    private static final String login = Logins.LOGIN_TRANSPORT;
    private static int shard;
    private static Long cid;
    private static Long pid;
    private static Long bid;
    private static Context context;
    private static Banner banner;

    private static String adgroupSrcGeo = TestRegionsSet.defaultAdgroupSrcGeo;
    private static String bannerCurentMinusGeo = TestRegionsSet.defaultBannerCurentMinusGeo;
    private static String adgroupGeoExceptCurrent = TestRegionsSet.adgroupGeoExceptCurrent;

    private static DirectJooqDbSteps dbSteps;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    @Step("Создаем новую кампанию, с группой и баннером, полностью модерируем и отправляем в БК")
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        dbSteps =  api.userSteps.getDirectJooqDbSteps().useShard(shard);

        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        PhrasesRecord phrasesRecord = dbSteps.adGroupsSteps().getPhrases(pid);
        phrasesRecord.setGeo(adgroupSrcGeo);
        dbSteps.adGroupsSteps().updatePhrases(phrasesRecord);

        dbSteps.bannersSteps().saveBannersMinusGeo(bid, BannersMinusGeoType.current, bannerCurentMinusGeo);

        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        RunBsTransportScriptResponse
                resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        assumeThat("новая кампания отправлена в БК", campaign, notNullValue());
        context = campaign != null ? campaign.getContext(pid) : null;
        banner = context != null ? context.getBanner(bid) : null;
        assumeThat("в БК отправлен баннер", banner, notNullValue());
    }

    @Test
    @Title("Отправка в БК группы баннеров с учетом минус-регионов, проверяем Context.UpdateInfo")
    public void testContextUpdateInfo() {
        assertThat("условия показа отправлены в БК", context, notNullValue());
        assertThat("условия показа отправлены в БК с UpdateInfo=1",
                context.getUpdateInfo(), equalTo(1));
    }

    @Test
    @Title("Отправка в БК баннера с учетом минус-регионов, проверяем Banner.UpdateInfo")
    public void testBannerUpdateInfo() {
        assumeThat("баннер отправлен в БК", banner, notNullValue());
        assertThat("баннер отправлен в БК с UpdateInfo=1",
                banner.getUpdateInfo(), equalTo(1));
    }

    @Test
    @Title("Отправка в БК группы баннеров с учетом минус-регионов, проверяем Context.Geo")
    public void testContextGeo() {
        assumeThat("условия показа отправлены в БК", context, notNullValue());
        assertThat("условия показа отправлены в БК с соответствующим значением Geo",
                context.getGeo(), containsInAnyOrder(adgroupGeoExceptCurrent.split(",")));
    }

    @Test
    @Title("Отправка в БК баннера с учетом минус-регионов, проверяем состояние записи в БД banners_minus_geo[type=bs_synced]")
    public void testBannerBsSyncedMinusGeo() {
        BannersMinusGeoRecord minusGeo = dbSteps.bannersSteps().getBannersMinusGeo(bid, BannersMinusGeoType.bs_synced);
        assertThat("баннер после отправки в БК, в БД находится с соответствующими минус-регионами типа bs_synced",
                minusGeo == null ? null : minusGeo.getMinusGeo(), equalTo(bannerCurentMinusGeo));
    }

}
