package ru.yandex.autotests.directintapi.bstransport.main.group.minus_geo;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersMinusGeoType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusshow;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersMinusGeoRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TestRegionsSet;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by sco76 on 14.09.17.
 * https://st.yandex-team.ru/TESTIRT-11693
 */

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issues({@Issue("https://st.yandex-team.ru/DIRECT-63267"), @Issue("https://st.yandex-team.ru/DIRECT-69547")})
@Title("Транспорт: отправка одиночного, побывавшего в БК баннера, у которого не менялись минус-регионы")
@Stories(StoriesNames.MINUS_GEO)
@Features(FeatureNames.GROUPS)
@RunWith(Parameterized.class)
public class BsTransportOfSyncedMinusGeoForTextOldBannerTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    @ClassRule
    public static final ApiSteps API = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static int shard;
    private static Long cid;
    private static Long pid;
    private static Long bid;
    private static Context context;
    private static Banner banner;
    private static String defaultAdgroupSrcGeo = TestRegionsSet.defaultAdgroupSrcGeo;
    private static String defaultBannerCurentMinusGeo = TestRegionsSet.defaultBannerCurentMinusGeo;
    private static String defaultBannerBsSyncedMinusGeo = TestRegionsSet.defaultBannerBsSyncedMinusGeo;
    private static String adgroupGeoExceptCurrent = TestRegionsSet.adgroupGeoExceptCurrent;
    private static String adgroupGeoExceptBsSynced = TestRegionsSet.adgroupGeoExceptBsSynced;
    private static String wholeWorldGeo = TestRegionsSet.wholeWorldGeo;
    private static String wholeWorldGeoExceptCurrent = TestRegionsSet.wholeWorldGeoExceptCurrent;
    private static DirectJooqDbSteps dbSteps;
    private static HashMap<Integer, Boolean> testDataPreparedWithParams = new HashMap<>();
    @Parameterized.Parameter(0)
    public int testCaseNumber;

    @Parameterized.Parameter(1)
    public PhrasesStatuspostmoderate adgroupStatusPostModerate;

    @Parameterized.Parameter(2)
    public PhrasesStatusbssynced adgroupStatusBsSynced;

    @Parameterized.Parameter(3)
    public BannersStatuspostmoderate bannerStatusPostModerate;

    @Parameterized.Parameter(4)
    public BannersStatusshow bannerStatusShow;

    @Parameterized.Parameter(5)
    public BannersStatusbssynced bannerStatusBsSynced;

    @Parameterized.Parameter(6)
    public String adgroupSrcGeo;

    @Parameterized.Parameter(7)
    public String bannerMinusGeo;

    @Parameterized.Parameter(8)
    public UpdateInfo resContextUpdateInfo;

    @Parameterized.Parameter(9)
    public UpdateInfo resBannerUpdateInfo;

    @Parameterized.Parameter(10)
    public StopFlag resBannerStop;

    @Parameterized.Parameter(11)
    public String resContextGeo;

    @Parameterized.Parameter(12)
    public String resBannerBsSyncedMinusGeo;

    @Parameterized.Parameters(name = "Номер тест-кейса: {0}, свойства группы/баннера: "
            + "adgroupStatusPostModerate={1}, "
            + "adgroupStatusBsSynced={2}, "
            + "bannerStatusPostModerate={3}, "
            + "bannerStatusShow={4}, "
            + "bannerStatusBsSynced={5}, "
            + "adgroupGeo={6}, "
            + "bannerMinusGeo={7}, ")
    public static Collection<Object[]> testData() {
        return Arrays.asList(
                new Object[]{49, PhrasesStatuspostmoderate.Yes, PhrasesStatusbssynced.No, BannersStatuspostmoderate.Yes,
                        BannersStatusshow.Yes, BannersStatusbssynced.No, defaultAdgroupSrcGeo,
                        defaultBannerCurentMinusGeo, UpdateInfo.UPDATE, UpdateInfo.UPDATE, StopFlag.RESUME,
                        adgroupGeoExceptCurrent, defaultBannerCurentMinusGeo},
                new Object[]{50, PhrasesStatuspostmoderate.Rejected, PhrasesStatusbssynced.No,
                        BannersStatuspostmoderate.Yes, BannersStatusshow.Yes, BannersStatusbssynced.No,
                        defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo, UpdateInfo.UPDATE, UpdateInfo.SKIP,
                        StopFlag.STOP, defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo},
                new Object[]{51, PhrasesStatuspostmoderate.Rejected, PhrasesStatusbssynced.No,
                        BannersStatuspostmoderate.Yes, BannersStatusshow.No, BannersStatusbssynced.No,
                        defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo, UpdateInfo.UPDATE, UpdateInfo.SKIP,
                        StopFlag.STOP, defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo},
                new Object[]{52, PhrasesStatuspostmoderate.No, PhrasesStatusbssynced.No, BannersStatuspostmoderate.Yes,
                        BannersStatusshow.Yes, BannersStatusbssynced.No, defaultAdgroupSrcGeo, null, UpdateInfo.SKIP,
                        UpdateInfo.UPDATE, StopFlag.RESUME, null, null},
                new Object[]{53, PhrasesStatuspostmoderate.No, PhrasesStatusbssynced.Yes, BannersStatuspostmoderate.Yes,
                        BannersStatusshow.Yes, BannersStatusbssynced.No, defaultAdgroupSrcGeo, null, UpdateInfo.SKIP,
                        UpdateInfo.UPDATE, StopFlag.RESUME, null, null},
                new Object[]{54, PhrasesStatuspostmoderate.Rejected, PhrasesStatusbssynced.Yes,
                        BannersStatuspostmoderate.Yes, BannersStatusshow.Yes, BannersStatusbssynced.No,
                        defaultAdgroupSrcGeo, null, UpdateInfo.SKIP, UpdateInfo.SKIP, StopFlag.STOP, null, null},
                new Object[]{55, PhrasesStatuspostmoderate.Yes, PhrasesStatusbssynced.No,
                        BannersStatuspostmoderate.Rejected, BannersStatusshow.Yes, BannersStatusbssynced.No,
                        defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo, UpdateInfo.UPDATE, UpdateInfo.SKIP,
                        StopFlag.STOP, defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo},
                new Object[]{56, PhrasesStatuspostmoderate.Yes, PhrasesStatusbssynced.No, BannersStatuspostmoderate.No,
                        BannersStatusshow.Yes, BannersStatusbssynced.Yes, defaultAdgroupSrcGeo,
                        defaultBannerBsSyncedMinusGeo, UpdateInfo.UPDATE, UpdateInfo.SKIP, StopFlag.RESUME,
                        adgroupGeoExceptBsSynced, defaultBannerBsSyncedMinusGeo},
                new Object[]{57, PhrasesStatuspostmoderate.Yes, PhrasesStatusbssynced.No, BannersStatuspostmoderate.No,
                        BannersStatusshow.Yes, BannersStatusbssynced.No, defaultAdgroupSrcGeo,
                        defaultBannerBsSyncedMinusGeo, UpdateInfo.UPDATE, UpdateInfo.SKIP, StopFlag.RESUME,
                        adgroupGeoExceptBsSynced, defaultBannerBsSyncedMinusGeo},
                new Object[]{58, PhrasesStatuspostmoderate.Rejected, PhrasesStatusbssynced.No,
                        BannersStatuspostmoderate.Rejected, BannersStatusshow.Yes, BannersStatusbssynced.No,
                        defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo, UpdateInfo.UPDATE, UpdateInfo.SKIP,
                        StopFlag.STOP, defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo},
                new Object[]{59, PhrasesStatuspostmoderate.Rejected, PhrasesStatusbssynced.No,
                        BannersStatuspostmoderate.No, BannersStatusshow.Yes, BannersStatusbssynced.Yes,
                        defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo, UpdateInfo.UPDATE, UpdateInfo.SKIP,
                        StopFlag.STOP, defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo},
                new Object[]{60, PhrasesStatuspostmoderate.Rejected, PhrasesStatusbssynced.No,
                        BannersStatuspostmoderate.No, BannersStatusshow.No, BannersStatusbssynced.Yes,
                        defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo, UpdateInfo.UPDATE, UpdateInfo.SKIP,
                        StopFlag.STOP, defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo},
                new Object[]{61, PhrasesStatuspostmoderate.No, PhrasesStatusbssynced.No,
                        BannersStatuspostmoderate.Rejected, BannersStatusshow.Yes, BannersStatusbssynced.No,
                        defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo, UpdateInfo.SKIP, UpdateInfo.SKIP,
                        StopFlag.STOP, null, defaultBannerBsSyncedMinusGeo},
                new Object[]{62, PhrasesStatuspostmoderate.Yes, PhrasesStatusbssynced.No, BannersStatuspostmoderate.Yes,
                        BannersStatusshow.No, BannersStatusbssynced.No, defaultAdgroupSrcGeo,
                        defaultBannerBsSyncedMinusGeo, UpdateInfo.UPDATE, UpdateInfo.SKIP, StopFlag.STOP,
                        defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo},
                new Object[]{63, PhrasesStatuspostmoderate.No, PhrasesStatusbssynced.No, BannersStatuspostmoderate.Yes,
                        BannersStatusshow.No, BannersStatusbssynced.No, defaultAdgroupSrcGeo,
                        defaultBannerBsSyncedMinusGeo, UpdateInfo.SKIP, UpdateInfo.SKIP, StopFlag.STOP, null,
                        defaultBannerBsSyncedMinusGeo},
                new Object[]{64, PhrasesStatuspostmoderate.Yes, PhrasesStatusbssynced.Yes,
                        BannersStatuspostmoderate.Yes, BannersStatusshow.No, BannersStatusbssynced.No,
                        defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo, UpdateInfo.SKIP, UpdateInfo.SKIP,
                        StopFlag.STOP, null, defaultBannerBsSyncedMinusGeo},
                new Object[]{65, PhrasesStatuspostmoderate.Yes, PhrasesStatusbssynced.Yes,
                        BannersStatuspostmoderate.Rejected, BannersStatusshow.Yes, BannersStatusbssynced.No,
                        defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo, UpdateInfo.SKIP, UpdateInfo.SKIP,
                        StopFlag.STOP, null, defaultBannerBsSyncedMinusGeo},
                new Object[]{66, PhrasesStatuspostmoderate.Yes, PhrasesStatusbssynced.Yes,
                        BannersStatuspostmoderate.Yes, BannersStatusshow.No, BannersStatusbssynced.No,
                        defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo, UpdateInfo.SKIP, UpdateInfo.SKIP,
                        StopFlag.STOP, null, defaultBannerBsSyncedMinusGeo},
                new Object[]{67, PhrasesStatuspostmoderate.Yes, PhrasesStatusbssynced.No, BannersStatuspostmoderate.Yes,
                        BannersStatusshow.Yes, BannersStatusbssynced.Yes, defaultAdgroupSrcGeo,
                        defaultBannerBsSyncedMinusGeo, UpdateInfo.UPDATE, UpdateInfo.SKIP, StopFlag.RESUME,
                        adgroupGeoExceptBsSynced, defaultBannerBsSyncedMinusGeo},
                new Object[]{68, PhrasesStatuspostmoderate.Yes, PhrasesStatusbssynced.No, BannersStatuspostmoderate.Yes,
                        BannersStatusshow.No, BannersStatusbssynced.Yes, defaultAdgroupSrcGeo,
                        defaultBannerBsSyncedMinusGeo, UpdateInfo.UPDATE, UpdateInfo.SKIP, StopFlag.STOP,
                        defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo},
                new Object[]{69, PhrasesStatuspostmoderate.Yes, PhrasesStatusbssynced.No,
                        BannersStatuspostmoderate.Rejected, BannersStatusshow.Yes, BannersStatusbssynced.Yes,
                        defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo, UpdateInfo.UPDATE, UpdateInfo.SKIP,
                        StopFlag.STOP, defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo},
                new Object[]{70, PhrasesStatuspostmoderate.Rejected, PhrasesStatusbssynced.No,
                        BannersStatuspostmoderate.Yes, BannersStatusshow.Yes, BannersStatusbssynced.Yes,
                        defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo, UpdateInfo.UPDATE, UpdateInfo.SKIP,
                        StopFlag.STOP, defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo},
                new Object[]{71, PhrasesStatuspostmoderate.Rejected, PhrasesStatusbssynced.No,
                        BannersStatuspostmoderate.Yes, BannersStatusshow.No, BannersStatusbssynced.Yes,
                        defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo, UpdateInfo.UPDATE, UpdateInfo.SKIP,
                        StopFlag.STOP, defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo},
                new Object[]{72, PhrasesStatuspostmoderate.Yes, PhrasesStatusbssynced.Yes,
                        BannersStatuspostmoderate.Yes, BannersStatusshow.Yes, BannersStatusbssynced.No,
                        defaultAdgroupSrcGeo, defaultBannerBsSyncedMinusGeo, UpdateInfo.SKIP, UpdateInfo.UPDATE,
                        StopFlag.RESUME, null, defaultBannerBsSyncedMinusGeo},
                new Object[]{73, PhrasesStatuspostmoderate.Yes, PhrasesStatusbssynced.No, BannersStatuspostmoderate.Yes,
                        BannersStatusshow.Yes, BannersStatusbssynced.No, wholeWorldGeo, defaultBannerCurentMinusGeo,
                        UpdateInfo.UPDATE, UpdateInfo.UPDATE, StopFlag.RESUME, wholeWorldGeoExceptCurrent,
                        defaultBannerCurentMinusGeo},
                new Object[]{74, PhrasesStatuspostmoderate.Yes, PhrasesStatusbssynced.Yes,
                        BannersStatuspostmoderate.Yes, BannersStatusshow.Yes, BannersStatusbssynced.No, wholeWorldGeo,
                        defaultBannerBsSyncedMinusGeo, UpdateInfo.SKIP, UpdateInfo.UPDATE, StopFlag.RESUME, null,
                        defaultBannerBsSyncedMinusGeo}
        );
    }

    @BeforeClass
    @Step("Создаем новую кампанию, с группой и баннером, полностью модерируем и отправляем в БК")
    public static void beforeClass() {
        shard = API.userSteps.clientFakeSteps().getUserShard(LOGIN);
        dbSteps = API.userSteps.getDirectJooqDbSteps().useShard(shard);

        cid = API.userSteps.campaignSteps().addDefaultTextCampaign();

        API.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);

        pid = API.userSteps.adGroupsSteps().addDefaultGroup(cid);
        bid = API.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = API.userSteps.keywordsSteps().addDefaultKeyword(pid);

        API.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        API.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        API.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);

        RunBsTransportScriptResponse
                resp = API.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign =
                API.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        assumeThat("новая кампания отправлена в БК", campaign, notNullValue());
        context = campaign != null ? campaign.getContext(pid) : null;
        banner = context != null ? context.getBanner(bid) : null;
        assumeThat("в БК отправлен баннер, первой итерацией", banner, notNullValue());
    }

    @Before
    @Step("Применяем к созданным ранее группе/баннеру свойства из параметров теста, и запускаем итерацию транспорта")
    public void prepareTestData() {
        if (testDataPreparedWithParams.getOrDefault(testCaseNumber, false)) {
            return;
        }

        PhrasesRecord phrasesRecord = dbSteps.adGroupsSteps().getPhrases(pid);
        phrasesRecord.setStatuspostmoderate(adgroupStatusPostModerate);
        phrasesRecord.setStatusbssynced(adgroupStatusBsSynced);
        phrasesRecord.setGeo(adgroupSrcGeo);
        dbSteps.adGroupsSteps().updatePhrases(phrasesRecord);

        BannersRecord bannersRecord = dbSteps.bannersSteps().getBanner(bid);
        bannersRecord.setStatuspostmoderate(bannerStatusPostModerate);
        bannersRecord.setStatusbssynced(bannerStatusBsSynced);
        bannersRecord.setStatusshow(bannerStatusShow);
        dbSteps.bannersSteps().updateBanners(bannersRecord);

        if (bannerMinusGeo == null) {
            dbSteps.bannersSteps().deleteBannersMinusGeo(bid, BannersMinusGeoType.current);
            dbSteps.bannersSteps().deleteBannersMinusGeo(bid, BannersMinusGeoType.bs_synced);
        } else {
            dbSteps.bannersSteps().saveBannersMinusGeo(bid, BannersMinusGeoType.current, bannerMinusGeo);
            dbSteps.bannersSteps().saveBannersMinusGeo(bid, BannersMinusGeoType.bs_synced, bannerMinusGeo);
        }


        API.userSteps.campaignFakeSteps().setStatusBsSynced(cid, "No");
        RunBsTransportScriptResponse resp =
                API.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(shard, cid);
        Campaign campaign =
                API.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        banner = context != null ? context.getBanner(bid) : null;

        testDataPreparedWithParams.put(testCaseNumber, true);
    }

    @Test
    @Title("Отправка в БК группы баннеров с учетом минус-регионов, проверяем Context.UpdateInfo")
    public void testContextUpdateInfo() {
        if (resContextUpdateInfo == null) {
            assertThat("условия показа не отправлены в БК", context, nullValue());
        } else {
            assertThat("условия показа отправлены в БК", context, notNullValue());
            assertThat("условия показа отправлены в БК с соответствующим значением UpdateInfo",
                    context.getUpdateInfo(), equalTo(resContextUpdateInfo.value()));
        }
    }

    @Test
    @Title("Отправка в БК баннера с учетом минус-регионов, проверяем Banner.UpdateInfo")
    public void testBannerUpdateInfo() {
        if (resBannerUpdateInfo == null) {
            assertThat("баннер не отправлен в БК", banner, nullValue());
        } else {
            assumeThat("баннер отправлен в БК", banner, notNullValue());
            assertThat("баннер отправлен в БК с соответствующим значением UpdateInfo",
                    banner.getUpdateInfo(), equalTo(resBannerUpdateInfo.value()));
        }
    }

    @Test
    @Title("Отправка в БК баннера с учетом минус-регионов, проверяем Banner.Stop")
    public void testBannerStop() {
        if (resBannerStop != null) {
            assumeThat("баннер отправлен в БК", banner, notNullValue());
            assertThat("баннер отправлен в БК с соответствующим значением Stop",
                    banner.getStop(), equalTo(resBannerStop.value()));
        }
    }

    @Test
    @Title("Отправка в БК группы баннеров с учетом минус-регионов, проверяем Context.Geo")
    public void testContextGeo() {
        if (resContextGeo != null) {
            assumeThat("условия показа отправлены в БК", context, notNullValue());
            String[] resContextGeoList;
            if (resContextGeo.equals("")) {
                resContextGeoList = new String[]{};
            } else {
                resContextGeoList = resContextGeo.split(",");
            }
            assertThat("условия показа отправлены в БК с соответствующим значением Geo",
                    context.getGeo(), containsInAnyOrder(resContextGeoList));
        }
    }

    @Test
    @Title("Отправка в БК баннера с учетом минус-регионов, проверяем состояние записи в БД banners_minus_geo[type=bs_synced]")
    public void testBannerBsSyncedMinusGeo() {
        BannersMinusGeoRecord minusGeo = dbSteps.bannersSteps().getBannersMinusGeo(bid, BannersMinusGeoType.bs_synced);
        if (resBannerBsSyncedMinusGeo == null) {
            assertThat("баннер после отправки в БК, в БД находится с соответствующими минус-регионами типа bs_synced",
                    minusGeo, nullValue());
        } else {
            assertThat("баннер после отправки в БК, в БД находится с соответствующими минус-регионами типа bs_synced",
                    minusGeo == null ? null : minusGeo.getMinusGeo(), equalTo(resBannerBsSyncedMinusGeo));
        }
    }

}
