package ru.yandex.autotests.directintapi.bstransport.main.group.parameters;

import java.util.Arrays;

import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.PerformanceBannersRule;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static org.junit.Assert.assertThat;

/**
 * Created by Sco76 on 2018-07-25
 * https://st.yandex-team.ru/DIRECT-82671
 */

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-82671")
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Features({FeatureNames.SMART_BANNERS, FeatureNames.DYN_GROUPS})
@Title("Проверка отправки ClickUrlTail в зависимости от типа кампании")
@RunWith(Parameterized.class)
public class BsTransportOfClickUrlTail {
    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    @ClassRule
    public static final ApiSteps API = new ApiSteps().as(LOGIN);
    private static final int SHARD = API.userSteps.clientFakeSteps().getUserShard(LOGIN);
    private static PerformanceBannersRule bannersRule = new PerformanceBannersRule().withUlogin(LOGIN);
    @ClassRule
    public static final DirectCmdRule cmdRule =
            DirectCmdRule.defaultRule().as(Logins.LOGIN_SUPER).withRules(bannersRule);
    private static TransportHelpSteps helpSteps = new TransportHelpSteps(API);

    @Parameterized.Parameter(0)
    public String tailOnCampaign;

    @Parameterized.Parameter(1)
    public String tailOnGroup;

    @Parameterized.Parameters(name = "Params on campaign - {0}, params on adgroup - {1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"", "utm_source_group=yandex"},
                {"utm_source_camp=yandex", ""},
                {"utm_source_camp=yandex", "utm_source_group=yandex"}
        });
    }

    @Test
    @Title("Отправка ClickUrlTail у динамической кампании")
    public void testTransportOfClickUrlTailInDynamicCampaign() {
        Long cid = API.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long pid = API.userSteps.adGroupsSteps().addDefaultGroupDynamic(cid);
        API.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(pid);
        Long bid = API.userSteps.adsSteps().addDefaultDynamicTextAd(pid);

        setupParamsOnCampaignAndAdGroup(cid, pid);

        API.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        API.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        API.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        RunBsTransportScriptResponse resp =
                API.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(SHARD, cid);
        Campaign campaign =
                API.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign.getContext(pid);
        assertThat("У ДТО поле отправляется", context.getResources().getClickUrlTail(), notNullValue());
        assertThat("Отправилось корректное поле ClickUrlTail", context.getResources().getClickUrlTail(),
                equalTo(!tailOnGroup.equals("") ? tailOnGroup : tailOnCampaign));
    }

    @Test
    @Title("Отправка ClickUrlTail у смарт-кампании")
    public void testTransportOfClickUrlTailInPerformanceCampaign() {
        Long cid = bannersRule.getCampaignId();
        Long pid = bannersRule.getGroupId();

        setupParamsOnCampaignAndAdGroup(cid, pid);
        helpSteps.makePerformanceCampaignReadyForSendingToBS(bannersRule, SHARD);

        RunBsTransportScriptResponse resp =
                API.userSteps.getDarkSideSteps().getTransportSteps().sendSyncedCampaign(SHARD, cid);
        Campaign campaign =
                API.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign.getContext(pid);
        assertThat("У смарта поле отправляется", context.getResources().getClickUrlTail(), notNullValue());
        assertThat("Отправилось корректное поле ClickUrlTail", context.getResources().getClickUrlTail(),
                equalTo(!tailOnGroup.equals("") ? tailOnGroup : tailOnCampaign));
    }

    @Test
    @Title("Отправка ClickUrlTail у текстовой кампании")
    public void testTransportOfClickUrlTailInTextCampaign() {
        Long cid = API.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = API.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long keywordId = API.userSteps.keywordsSteps().addDefaultKeyword(pid);
        Long bid = API.userSteps.adsSteps().addDefaultTextAd(pid);

        setupParamsOnCampaignAndAdGroup(cid, pid);

        API.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        API.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        API.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        API.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        RunBsTransportScriptResponse resp =
                API.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(SHARD, cid);
        Campaign campaign =
                API.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign.getContext(pid);
        assertThat("У текстовой кампании поле не отправляется", context.getResources().getClickUrlTail(), nullValue());
    }

    private void setupParamsOnCampaignAndAdGroup(Long cid, Long pid) {
        API.userSteps.adGroupsSteps()
                .adGroupsUpdate(new UpdateRequestMap()
                        .withAdGroups(new AdGroupUpdateItemMap()
                                .withId(pid)
                                .withTrackingParams(tailOnGroup)));
        API.userSteps.getDirectJooqDbSteps().useShard(SHARD).campaignsSteps()
                .updateHrefParams(cid, tailOnCampaign);
    }
}
