package ru.yandex.autotests.directintapi.bstransport.main.group.parameters.audiencetargetgoalids;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.retargetinglists.RetargetingListRuleOperatorEnum;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListTypeEnum;
import one.util.streamex.StreamEx;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PerfCreativesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.displaycanvas.ModerationInfo;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.steps.DarkSideSteps;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListAddItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleArgumentItemMap;
import ru.yandex.autotests.directapi.model.api5.retargetinglists.RetargetingListRuleItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.emptyList;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.nullValue;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType.cpm_banner;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType.cpm_geoproduct;
import static ru.yandex.autotests.directapi.model.retargeting.RetargetingGoalType.AUDIENCE_SEGMENT;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.TRUNK)
@Description("Тест на отправку AudienceSegmentGoalIds")
@Features(FeatureNames.GROUPS)
@Stories(StoriesNames.GROUP_PARAMS_AUDIENCESEGMENTGOALIDS)
@Issue("https://st.yandex-team.ru/DIRECT-94695")
@RunWith(Parameterized.class)
public class AudienceSegmentGoalIdsTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;
    private static DirectJooqDbSteps jooqDbSteps;
    private static DarkSideSteps darkSideSteps;

    @Rule
    public Trashman trashman = new Trashman(api);
    @Parameterized.Parameter(0)
    public String description;
    @Parameterized.Parameter(1)
    public PhrasesAdgroupType adgroupType;
    @Parameterized.Parameter(2)
    public boolean addAudienceSegments;
    @Parameterized.Parameter(3)
    public boolean shouldHaveAudienceSegmentGoalIds;
    private Campaign campaign;
    private Long pid;
    private Long rcId;
    private Long atId;
    private List<Long> audienceSegmentGoalIds;

    @Parameterized.Parameters(name = "{0}")
    public static Iterable<Object[]> parameters() {
        return Arrays.asList(
                new Object[]{"Группа cpm_banner с нацеливанием на аудиторию", cpm_banner, true, false},
                new Object[]{"Группа cpm_geoproduct", cpm_geoproduct, true, true},
                new Object[]{"Группа cpm_geoproduct без нацеливания на аудиторию", cpm_geoproduct, false, true}
        );
    }

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        darkSideSteps = api.userSteps.getDarkSideSteps();
    }

    @After
    @Step("Утилизация тестовых данных")
    public void after() {
        api.userSteps.audienceTargetsSteps().delete(LOGIN, atId);
        api.userSteps.retargetingListsSteps().delete(LOGIN, rcId);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        Long creativeId = jooqDbSteps.perfCreativesSteps().saveDefaultCanvasCreativesForClient(Long.parseLong(User.get(LOGIN).getClientID()));
        Long cid = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign(LOGIN);
        pid = api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(cid, LOGIN);
        Long bid = api.userSteps.adsSteps().addDefaultCpmBannerAdBuilderAd(pid, creativeId, LOGIN);

        audienceSegmentGoalIds = addAudienceSegments
                ? StreamEx.of(api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, AUDIENCE_SEGMENT)).limit(5).sorted().toList()
                : emptyList();
        RetargetingListAddItemMap retargetingListAddItemMap = createRetargetingList(audienceSegmentGoalIds);

        rcId = api.userSteps.retargetingListsSteps().add(LOGIN, new AddRequestMap().withRetargetingLists(retargetingListAddItemMap)).get(0);
        atId = api.userSteps.audienceTargetsSteps().addWithRetargetingList(LOGIN, pid, rcId);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        jooqDbSteps.bannersPerformanceSteps().setCreativeStatusModerate(cid, pid, bid, BannersPerformanceStatusmoderate.Yes);
        jooqDbSteps.perfCreativesSteps().setModerateInfo(creativeId, new ModerationInfo().generateTestData().toString());
        jooqDbSteps.perfCreativesSteps().setStatusModerate(creativeId, PerfCreativesStatusmoderate.Yes);
        jooqDbSteps.adGroupsSteps().setType(pid, adgroupType);
        RunBsTransportScriptResponse resp = darkSideSteps.getTransportSteps().sendNewCampaign(shard, cid);
        campaign = darkSideSteps.getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
    }

    @Test
    public void testAudienceSegmentGoalIdsTest() {
        List<Long> result = campaign.getContext(pid).getAudienceSegmentGoalIds();
        if (shouldHaveAudienceSegmentGoalIds) {
            assertThat(result, equalTo(audienceSegmentGoalIds));
        } else {
            assertThat(result, nullValue());
        }
    }

    private RetargetingListAddItemMap createRetargetingList(List<Long> audienceSegmentGoalIds) {
        RetargetingListRuleItemMap[] retargetingListRuleItems = StreamEx.of(audienceSegmentGoalIds)
                .append(StreamEx.of(api.userSteps.retargetingSteps().getRetargetingGoalIDsByType(LOGIN, RetargetingGoalType.GOAL)).limit(5))
                .map(goalId -> new RetargetingListRuleArgumentItemMap().withMembershipLifeSpan(RandomUtils.nextInt(1, 90)).withExternalId(goalId))
                .sortedByInt(value -> RandomUtils.nextInt(0, 1000))
                .pairMap((first, second) -> new RetargetingListRuleItemMap()
                        .withArgumentItems(first, second)
                        .withOperator(RandomUtils.nextInt(0, 2) == 1 ? RetargetingListRuleOperatorEnum.ALL : RetargetingListRuleOperatorEnum.ANY))
                .toList()
                .toArray(new RetargetingListRuleItemMap[0]);

        return new RetargetingListAddItemMap()
                .withType(RetargetingListTypeEnum.AUDIENCE)
                .withName("Name" + RandomStringUtils.randomAlphabetic(3))
                .withDescription("Description" + RandomStringUtils.randomAlphabetic(3))
                .withRules(retargetingListRuleItems);
    }
}
