package ru.yandex.autotests.directintapi.bstransport.main.group.parameters.contenttargeting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PerfCreativesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupAdditionalTargetingsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.displaycanvas.ModerationInfo;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.multipliers.BsAtom;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupAdditionalTargetingsTargetingMode.filtering;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupAdditionalTargetingsTargetingMode.targeting;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupAdditionalTargetingsTargetingType.content_categories;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupAdditionalTargetingsValueJoinType.all;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.enums.AdgroupAdditionalTargetingsValueJoinType.any;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки TargetingExpression на категории контента на уровне группы")
@Stories(StoriesNames.GROUP_PARAMS_TARGETINGEXPR_CONTENT)
@Features(FeatureNames.GROUPS)
@Issue("https://st.yandex-team.ru/DIRECT-118815")
@ParametersAreNonnullByDefault
public class BsTransportOfCpmBannerContentTargeting {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static int shard;

    private Long cid;
    private Long pid;
    private DirectJooqDbSteps jooqDbSteps;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.getDarkSideSteps().getClientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void init() {
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        long clientId = Long.parseLong(api.userSteps.clientFakeSteps().getClientData(LOGIN).getClientID());
        Long creativeId = jooqDbSteps.perfCreativesSteps().saveDefaultCanvasCreativesForClient(clientId);

        cid = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign(LOGIN);
        //создаем группу cpm-banner с ключевыми словами
        pid = api.userSteps.adGroupsSteps().addDefaultCpmBannerKeywordsAdGroup(cid);
        List<Long> keywordIds = api.userSteps.keywordsSteps().addDefaultKeywords(pid, 1);
        long bid = api.userSteps.adsSteps().addDefaultCpmBannerAdBuilderAd(pid, creativeId);

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordIds.get(0));

        jooqDbSteps.bannersPerformanceSteps()
                .setCreativeStatusModerate(cid, pid, bid, BannersPerformanceStatusmoderate.Yes);
        jooqDbSteps.perfCreativesSteps().setModerateInfo(creativeId,
                new ModerationInfo().generateTestData().toString());
        jooqDbSteps.perfCreativesSteps().setStatusModerate(creativeId, PerfCreativesStatusmoderate.Yes);
    }

    @Test
    public void testTargetingExpression() {
        jooqDbSteps.adGroupsInternalSteps().addAdGroupAdditionalTargetings(
                new AdgroupAdditionalTargetingsRecord()
                        .setPid(pid)
                        .setTargetingMode(targeting)
                        .setTargetingType(content_categories)
                        .setValueJoinType(any)
                        .setValue("[4294970306, 4294970305, 4294968349, 4294968345]"));
        jooqDbSteps.adGroupsInternalSteps().addAdGroupAdditionalTargetings(
                new AdgroupAdditionalTargetingsRecord()
                        .setPid(pid)
                        .setTargetingMode(filtering)
                        .setTargetingType(content_categories)
                        .setValueJoinType(all)
                        .setValue("[4294970300, 4294970299, 4294968341, 4294968338]"));

        RunBsTransportScriptResponse resp
                = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, cid);

        Context context = campaign.getContext(pid);
        ArrayList<List<BsAtom>> expectedTargetingExpression = new ArrayList<>();
        expectedTargetingExpression.add(Arrays.asList(
                BsAtom.of("content-category", "equal", "4294968345"),
                BsAtom.of("content-category", "equal", "4294968349"),
                BsAtom.of("content-genre", "equal", "4294970305"),
                BsAtom.of("content-genre", "equal", "4294970306")
        ));
        expectedTargetingExpression.addAll(Arrays.asList(
                Collections.singletonList(BsAtom.of("content-category", "not equal", "4294968338")),
                Collections.singletonList(BsAtom.of("content-category", "not equal", "4294968341")),
                Collections.singletonList(BsAtom.of("content-genre", "not equal", "4294970299")),
                Collections.singletonList(BsAtom.of("content-genre", "not equal", "4294970300"))
        ));
        assertThat(context.getTargetingExpression(), beanDiffer(expectedTargetingExpression));
    }
}
