package ru.yandex.autotests.directintapi.bstransport.main.group.parameters.minusphrases;

import java.util.Collection;
import java.util.List;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MinusWordsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.irt.testutils.allure.AllureUtils;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Arrays.asList;
import static java.util.Collections.singletonList;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-90582")
@Title("Проверка отправки CONTEXT.MinusPhrases для текстовой кампании")
@Stories(StoriesNames.GROUP_PARAMS_MINUSPHRASES)
@Features(FeatureNames.GROUPS)
@RunWith(Parameterized.class)
public class BsTransportOfGroupLibMinusPhrasesTest {
    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final String FAKE_MINUSWORD = "libworkaround4";  //Todo: using it until api will apply minus phrases.

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static int shard;
    private static Long clientId;

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(0)
    public String[] adGroupMinusWords;

    @Parameterized.Parameter(1)
    public List<String[]> adGroupLibMinusWords;

    @Parameterized.Parameter(2)
    public String[] expectedMinusWords;

    public static Context context;

    @Parameterized.Parameters()
    public static Collection<Object[]> data() {
        return asList(
                new Object[]{new String[]{"минусслово"},
                        singletonList(new String[]{"минус фраза", "минусслово"}),
                        new String[]{"минус фраза", "минусслово"}},
                new Object[]{new String[]{"минусслово1", "минусслово2"},
                        asList(new String[]{"минус фраза1"}, new String[]{"минусслово3"}),
                        new String[]{"минус фраза1", "минусслово1", "минусслово2", "минусслово3"}},
                new Object[]{new String[]{"минус фраза"},
                        singletonList(new String[]{"минус фраза"}),
                        new String[]{"минус фраза"}},
                new Object[]{new String[]{"минус !фраза1", "минусслово", "минус +фраза2"},
                        singletonList(new String[]{"минус фраза"}),
                        new String[]{"минус !фраза1", "минус +фраза2", "минус фраза", "минусслово"}},
                new Object[]{new String[]{"\"минусслово\""},
                        singletonList(new String[]{"минус фраза"}),
                        new String[]{"минусслово ~0", "минус фраза"}},
                new Object[]{new String[]{"\"минус фраза1\"", "\"минус фраза2\""},
                        singletonList(new String[]{"\"минус фраза3\""}),
                        new String[]{"минус фраза1 ~0", "минус фраза2 ~0", "минус фраза3 ~0"}}
        );
    }

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        clientId = Long.valueOf(User.get(LOGIN).getClientID());
    }

    @Before
    @Step("Подготовка: создаем кампанию с минус-фразами на группу в json формате")
    public void prepareTestData() {

        DirectJooqDbSteps directJooqDbSteps =
                api.userSteps.getDirectJooqDbSteps().useShard(shard);
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long bidId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);

        if (adGroupMinusWords.length > 0) {
            api.userSteps.adGroupsSteps().adGroupsUpdate(
                    new UpdateRequestMap().withAdGroups(
                            new AdGroupUpdateItemMap()
                                    .withId(pid)
                                    .withNegativeKeywords(FAKE_MINUSWORD)
                    )
            );
            MinusWordsRecord mwRecord = directJooqDbSteps.adGroupsSteps().getMinusWordsByPid(pid);
            mwRecord.setMwText(JsonUtils.toString(adGroupMinusWords, true)); //хак: обновляем только текст без mw_hash
            directJooqDbSteps.adGroupsSteps().updateMinusWords(mwRecord);
        }

        adGroupLibMinusWords.forEach(libMw -> {
            Long mwId = directJooqDbSteps.minusWordsSteps().addLibMinusWord(clientId, JsonUtils.toString(libMw, true));
            directJooqDbSteps.adGroupsSteps().addAdGroupMinusWords(pid, mwId);
        });

        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(bidId);

        RunBsTransportScriptResponse
                resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        context = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid)
                .getContext(pid);
    }

    @Test
    @Title("Проверяем поле Context.MinusPhrases для текстового баннера")
    @Description("Ожидаем, что в Context.MinusPhrases будет список из ppc.minus_words.mw_text для данного pid")
    public void testContextMinusPhrases() {
        AllureUtils.changeTestCaseTitle("Проверяем поле Context.MinusPhrases для minuswords.mw_text = " + JsonUtils
                .toString(adGroupMinusWords, true));
        assumeThat("в БК отправлена группа(контекст)", context, notNullValue());
        assumeThat("UpdateInfo отправленной группы " + UpdateInfo.UPDATE
                , context.getUpdateInfo(), equalTo(UpdateInfo.UPDATE.value()));

        List<String> expectedMinusPhrases = asList(expectedMinusWords);

        assertThat("отправленное в БК поле Context.MinusPhrases соответствуют ожиданиям",
                context.getMinusPhrases(),
                equalTo(expectedMinusPhrases));
    }
}
