package ru.yandex.autotests.directintapi.bstransport.main.group.parameters.mobile;

import java.util.Arrays;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.cmd.data.commons.group.Group;
import ru.yandex.autotests.direct.cmd.data.interest.TargetInterests;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.cmd.rules.MobileBannersRule;
import ru.yandex.autotests.direct.cmd.steps.retargeting.RetargetingHelper;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsRetargetingRecord;
import ru.yandex.autotests.direct.httpclient.TestEnvironment;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.GoalContext;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by buhter on 05/12/16.
 * https://st.yandex-team.ru/TESTIRT-10595
 */
@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(TagDictionary.RETARGETING)
@Tag(TagDictionary.BS_INTEGRATION)
@Issue("https://st.yandex-team.ru/DIRECT-58390")
@Title("Транспорт: группы с типом mobile_content, с интересом. Проверка GOAL_CONTEXT.Params")
@Stories(StoriesNames.GROUP_PARAMS_MOBILE)
@Features(FeatureNames.GROUPS)
public class BsTransportOfMobileGroupWithInterestTargetExpressionTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @ClassRule
    public static DirectCmdRule stepsClassRule = DirectCmdRule.defaultClassRule();

    private MobileBannersRule bannersRule;
    @Rule
    public DirectCmdRule cmdRule;
    private Long categoryId;
    private Long retId;
    private Long goalId;
    private Context context;

    public BsTransportOfMobileGroupWithInterestTargetExpressionTest() {
        categoryId = RetargetingHelper.getRandomTargetCategoryId();
        bannersRule = new MobileBannersRule()
                .overrideGroupTemplate(new Group().withTargetInterests(
                        Arrays.asList(
                                new TargetInterests()
                                        .withTargetCategoryId(categoryId)
                                        .withRetId(0)
                                        .withPriceContext(0.78d)
                                        .withAutobudgetPriority(3))
                        )
                )
                .withUlogin(LOGIN);
        cmdRule = DirectCmdRule.defaultRule().withRules(bannersRule);
    }

    @Before
    @Step("Подготовка данных")
    public void beforeClass() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        BidsRetargetingRecord bidsRetargeting = TestEnvironment.newDbSteps().useShardForLogin(LOGIN)
                .bidsSteps()
                .getBidsRetargetingRecordByPid(bannersRule.getGroupId()).get(0);
        retId = bidsRetargeting.getRetId();
        goalId = TestEnvironment.newDbSteps().useShardForLogin(LOGIN)
                .retargetingGoalsSteps()
                .getRetargetingGoalsByRetCondId(bidsRetargeting.getRetCondId()).get(0).getGoalId();

        Long cid = bannersRule.getCampaignId();
        Long pid = bannersRule.getGroupId();
        Long bid = bannersRule.getBannerId();
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        assumeThat("кампания отправляется в БК", campaign, notNullValue());
        context = campaign.getContext(pid);
        assumeThat("в кампании присутствует Context", context, notNullValue());

    }

    @Test
    public void testTransportOfInterestExpression() {
        GoalContext goalContext = context.getGoalContext(retId);
        String expectedExpression = String.format("%s:90", goalId);

        assumeThat("в Context присутствует GoalContext", goalContext, notNullValue());
        assertThat("при отправке GoalContext отправляется правильный Expression",
                goalContext.getExpression(),
                equalTo(expectedExpression));
    }
}

