package ru.yandex.autotests.directintapi.bstransport.main.group.parameters.mobilepricecoef;

import java.util.Map;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.MobileAdjustmentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки параметра MobilePriceCoef на уровне группы, добавление")
@Stories(StoriesNames.GROUP_PARAMS_MOBPRICECOEF)
@Features(FeatureNames.GROUPS)
@Issue("https://st.yandex-team.ru/DIRECT-42533")
public class BsTransportOfGroupMobilePriceCoefAddTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final Integer MOBILE_PRICE_COEF = 50;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;
    private Context context;


    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    public void before() {
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        RunBsTransportScriptResponse resp =
                api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Map<String, Map> contextMap = helpSteps.getContextMap(resp, cid, pid);
        assumeThat("в БК отправлен контекст (группа)", contextMap, notNullValue());
        assumeThat("в БК отправлена корректировка MobilePriceCoef со значение undef на уровне группы",
                contextMap.get(Context.MOBILE_PRICE_COEF), equalTo(null));
        assumeThat("в БК отправлена корректировка MobileIOSPriceCoef со значение undef на уровне группы",
                contextMap.get(Campaign.MOBILE_IOS_PRICE_COEF), equalTo(null));
        assumeThat("в БК отправлена корректировка MobileAndroidPriceCoef со значение undef на уровне группы",
                contextMap.get(Campaign.MOBILE_ANDROID_PRICE_COEF), equalTo(null));

        api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withMobileAdjustment(new MobileAdjustmentMap()
                                .withBidModifier(MOBILE_PRICE_COEF)
                        )
                        .withAdGroupId(pid)
        );

        resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);

        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        assumeThat("в БК отправлен контекст (группа)", context, notNullValue());
    }

    @Test
    @Title("Отправка в БК корректировки MobilePriceCoef на уровне группы при ее добавлении")
    public void testTransportOfGroupMobilePriceCoef() {
        assertThat("отправленная в БК корректировка MobilePriceCoef на уровне группы соответствует ожидаемой",
                context.getMobilePriceCoef(), equalTo(MOBILE_PRICE_COEF.toString()));
        assertThat("отправленная в БК корректировка MobileIOSPriceCoef на уровне группы соответствует ожидаемой",
                context.getMobileIOSPriceCoef(), equalTo(null));
        assertThat("отправленная в БК корректировка MobileAndroidPriceCoef на уровне группы соответствует ожидаемой",
                context.getMobileAndroidPriceCoef(), equalTo(null));
    }
}
