package ru.yandex.autotests.directintapi.bstransport.main.group.parameters.retargetingcoef;

import java.util.List;
import java.util.Map;

import com.google.common.collect.ImmutableList;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListGetItem;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.web.api.core.DirectRule;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.BidMultiplierConditionBuilder;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ExpressionCoefItem;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ExpressionCoefs;
import ru.yandex.autotests.directapi.darkside.model.multipliers.DirectAtom;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RetargetingAdjustmentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.directapi.darkside.model.BidMultiplierUtils.retargetingBsAtomContext;
import static ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign.RETARGETING_COEF;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.checkBsUnifiedMultipliers;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Title("Транспорт: проверка отправки параметра RetargetingCoef на уровне группы, доступность условия ретаргетинга")
@Stories(StoriesNames.CAMPAIGN_PARAMS_RETARGETINGCOEF)
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Issue("https://st.yandex-team.ru/DIRECT-42533")
public class BsTransportOfGroupRetargetingCoefGoalAccessibleTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final int COEF = 150;
    private static final int RETARGETING_NUM = 2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public DirectRule directRule = DirectRule.defaultRule().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;
    private Long cid;
    private Long pid;
    private static List<Long> retIds;
    private long goalId = 0;
    private Context context;
    private RunBsTransportScriptResponse resp;

    @BeforeClass
    public static void beforeClass() {

        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        retIds = helpSteps.addRetargetingListsForUserIfNotExists(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void before() {
        helpSteps.useDirectWebApiSteps(directRule.webApiSteps());
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withAdGroupId(pid)
                        .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                .withRetargetingConditionId(retIds.get(RETARGETING_NUM))
                                .withBidModifier(COEF)
                        )
        );
        RetargetingListGetItem retargetingListGetItem
                = api.userSteps.retargetingListsSteps().get(retIds.get(RETARGETING_NUM)).get(0);
        goalId = retargetingListGetItem.getRules().get(0).getArguments().get(0).getExternalId();
        api.userSteps.getDirectJooqDbSteps().useShard(shard).retargetingGoalsSteps()
                .setIsAccessible(retIds.get(RETARGETING_NUM), goalId, 0);

        resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Map<String, Map> contextMap = helpSteps.getContextMap(resp, cid, pid);
        assumeThat("в БК отправлен контекст (группа)", contextMap, notNullValue());
        assumeThat("в БК отправлена корректировка RetargetingCoef со значение undef на уровне группы",
                contextMap.get(RETARGETING_COEF), Matchers.equalTo(null));

        api.userSteps.getDirectJooqDbSteps().useShard(shard).retargetingGoalsSteps()
                .setIsAccessible(retIds.get(RETARGETING_NUM), goalId, 1);
        goalId = 0;
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, Status.NO);

        resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendCampaign(shard, cid);
        Campaign campaign =
                api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        assumeThat("в БК отправлен контекст (группа)", context, notNullValue());
    }

    @Test
    @Title("Отправка в БК корректировки RetargetingCoef на уровне группы")
    public void testTransportOfGroupRetargetingCoef() {
        assertThat("отправленная в БК корректировка RetargetingCoef на уровне группы содержит записи",
                context.getRetargetingCoef(), notNullValue());
        assertThat("отправленная в БК корректировка RetargetingCoef на уровне группы содержит ровно одну запись",
                context.getRetargetingCoef().size(), equalTo(1));

        // проверяем передачу в унифицированном формате
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, 0, cid);
        assumeThat("в БК отправлена кампания", campaign, notNullValue());

        ExpressionCoefs expressionCoefs = campaign.getContext(pid).getExpressionCoefs();
        assumeThat("Отправлен ExpessionCoefs у группы", expressionCoefs, notNullValue());

        List<ExpressionCoefItem> retargeringCoefs = expressionCoefs.getRetargeting();
        assumeThat("Отправлен ExpressionCoefs.Goal", retargeringCoefs, notNullValue());

        List<List<DirectAtom>> expectedExpression = BidMultiplierConditionBuilder.init()
                .and(retargetingBsAtomContext(Long.toString(retIds.get(RETARGETING_NUM))))
                .build();

        checkBsUnifiedMultipliers(retargeringCoefs,
                ImmutableList.of(COEF),
                ImmutableList.of(expectedExpression));
    }

    @After
    public void after() {
        if (goalId != 0) {
            api.userSteps.getDirectJooqDbSteps().useShard(shard).retargetingGoalsSteps()
                    .setIsAccessible(retIds.get(RETARGETING_NUM), goalId, 1);
        }
    }
}
