package ru.yandex.autotests.directintapi.bstransport.main.group.parameters.retargetingcoef;
import java.util.List;

import com.google.common.collect.ImmutableList;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.direct.web.api.core.DirectRule;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.BidMultiplierConditionBuilder;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ExpressionCoefItem;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.ExpressionCoefs;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.RetargetingCoef;
import ru.yandex.autotests.directapi.darkside.model.multipliers.DirectAtom;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.BidModifierAddMap;
import ru.yandex.autotests.directapi.model.api5.bidmodifiers.RetargetingAdjustmentMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingConditionGoalItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingConditionItemMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingConditionMap;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.iterableWithSize;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directapi.darkside.model.BidMultiplierUtils.retargetingBsAtomContext;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.checkBsUnifiedMultipliers;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;


/**
 * Created by buhter on 14/06/16.
 * https://st.yandex-team.ru/TESTIRT-9439
 */
@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки параметра RetargetingCoef на уровне группы" +
        ", для корректировки [не был на сайте]")
@Stories(StoriesNames.GROUP_PARAMS_RETARGETINGCOEF)
@Features(FeatureNames.GROUPS)
@Issue("https://st.yandex-team.ru/DIRECT-52517")
public class BsTransportOfGroupRetargetingCoefNewOnSiteTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    private static final int COEF = 50;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public DirectRule directRule = DirectRule.defaultRule().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    private static TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;
    private Long cid;
    private Long pid;
    private int[] retIds;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void before() {
        helpSteps.useDirectWebApiSteps(directRule.webApiSteps());
        cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);
        List<Long> goalIds = api.userSteps.retargetingSteps().getRetargetingGoalIDs(LOGIN);
        assumeThat("для логина " + LOGIN + "есть хотя бы одна цель", goalIds, iterableWithSize(greaterThan(0)));
        retIds = api.userSteps.retargetingSteps().addRetargetingConditions(
                new RetargetingConditionMap(api.type())
                        .withRetargetingConditionDescription("description")
                        .withRetargetingConditionName("name")
                        .withRetargetingConditionItems(new RetargetingConditionItemMap(api.type())
                                .withGoals(new RetargetingConditionGoalItemMap(api.type())
                                        .withGoalID(goalIds.get(0))
                                        .withTime(15))
                                .withType(RetargetingType.NOT)
                        )
        );
    }

    @Test
    @Title("Отправка в БК корректировки RetargetingCoef на уровне группы, корректировка [не был на сайте]")
    public void testTransportOfGroupOneRetargetingCoef() {
        api.userSteps.bidModifiersSteps().bidModifiersAdd(
                new BidModifierAddMap()
                        .withAdGroupId(pid)
                        .withRetargetingAdjustment(new RetargetingAdjustmentMap()
                                .withRetargetingConditionId(retIds[0])
                                .withBidModifier(COEF)
                        )
        );

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps().getTransportSteps().getClientDataRequestCampaign(resp, cid);
        Context context = campaign != null ? campaign.getContext(pid) : null;
        assumeThat("в БК отправлен контекст (группа)", context, notNullValue());
        assumeThat("в БК отправлена корректировка по ретаргетингу", context.getRetargetingCoef(), notNullValue());

        RetargetingCoef expected = new RetargetingCoef();
        expected.setCoef(COEF);
        expected.setExpression(helpSteps.getRetConditionsBSStyle((long) retIds[0]));
        assertThat("отправленная в БК корректировка RetargetingCoef на уровне группы содержит ровно одну запись",
                context.getRetargetingCoef().size(), equalTo(1));
        assertThat("отправленная в БК корректировка RetargetingCoef на уровне группы соответствует ожидаемой",
                context.getRetargetingCoef().get(String.valueOf(retIds[0])), beanEquals(expected));

        // проверяем передачу в унифицированном формате
        ExpressionCoefs expressionCoefs = campaign.getContext(pid).getExpressionCoefs();
        assumeThat("Отправлен ExpessionCoefs у группы", expressionCoefs, notNullValue());

        List<ExpressionCoefItem> retargeringCoefs = expressionCoefs.getRetargeting();
        assumeThat("Отправлен ExpressionCoefs.Goal", retargeringCoefs, notNullValue());

        List<List<DirectAtom>> expectedExpression = BidMultiplierConditionBuilder.init()
                .and(retargetingBsAtomContext(Long.toString(retIds[0])))
                .build();

        checkBsUnifiedMultipliers(retargeringCoefs,
                ImmutableList.of(COEF),
                ImmutableList.of(expectedExpression));
    }

}
