package ru.yandex.autotests.directintapi.bstransport.main.image.actions.creation;

import java.util.HashSet;
import java.util.Set;

import org.assertj.core.api.SoftAssertions;
import org.hamcrest.core.IsNull;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.direct.db.steps.JooqBannerImagesOpts;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.ImageType;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.darkside.model.ImageType.REGULAR;
import static ru.yandex.autotests.directapi.darkside.model.Status.NO;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка отправки в БК картиночного баннера в родительском баннере")
@Stories(StoriesNames.IMAGE_ACTION_CREATION)
@Features({FeatureNames.IMAGES, FeatureNames.NOT_FOR_FULL_EXPORT})
@Issue("https://st.yandex-team.ru/DIRECT-171884")
public class BsTransportOfNewImageBannerInSingleSendTest {

    private static final String LOGIN = Logins.LOGIN_TRANSPORT;
    public static final ImageType TYPE = ImageType.WIDE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Banner textBanner;
    private static Banner picBanner;

    @Before
    public void prepare() {
        TransportHelpSteps helpSteps = new TransportHelpSteps(api);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        String[] imageHashes = helpSteps.addImagesForUserIfNotExists(LOGIN, TYPE);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps()
                .addAd(new AdAddItemMap()
                        .withAdGroupId(pid)
                        .withTextAd(new TextAdAddMap()
                                .defaultTextAd()
                                .withAdImageHash(imageHashes[0])));
        Long imageId = api.userSteps.getDirectJooqDbSteps().useShard(shard).
                imagesSteps()
                .getBannerImagesByBid(bid)
                .getImageId();
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .setBannerImagesStatusModerate(imageId, BannerImagesStatusmoderate.Yes);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, NO);

        // добавляем флаг SINGLE_AD_TO_BS чтобы картиночная версия баннера отправилась в родительском баннере
        Set<JooqBannerImagesOpts> opts = new HashSet<>();
        opts.add(JooqBannerImagesOpts.SINGLE_AD_TO_BS);
        api.userSteps.getDirectJooqDbSteps()
                .useShard(shard)
                .imagesSteps()
                .setImageOpts(bid, opts);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .sendNewCampaign(shard, cid);

        Campaign campaign = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign.getContext(pid);
        assumeThat("в БК отправлен непустой Context", context, IsNull.notNullValue());
        textBanner = context.getBanner(bid);
        picBanner = context.getBanner(imageId);
    }

    @Test
    @Title("Отправка в БК картиночного баннера в родительском баннере")
    public void testTransportOfBannerWithAllPhrasesSuspended() {
        SoftAssertions soft = new SoftAssertions();
        soft.assertThat(textBanner)
                .as("баннер отправился в БК")
                .isNotNull();
        soft.assertThat(textBanner.getImages())
                .as("у баннера есть Images")
                .isNotNull();
        soft.assertThat(textBanner.getResources().getAutoVideoCreative()).
                as("у баннера есть AutoVideoCreative")
                .isNotNull();
        soft.assertThat(textBanner.getIsAutoVideo())
                .as("у баннера есть IsAutoVideo")
                .isEqualTo(1);
        soft.assertThat(textBanner.getImageType())
                .as("у баннера есть ImageType")
                .isEqualTo(REGULAR.getName());
        soft.assertThat(picBanner)
                .as("картиночная версия баннера не отправилась в БК")
                .isNull();
        soft.assertAll();
    }
}
