package ru.yandex.autotests.directintapi.bstransport.main.image.actions.creation.queue;

import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BsExportQueueRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.autotests.directintapi.bstransport.matchers.QueueRecordMatcher;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static ru.yandex.autotests.directapi.darkside.model.ImageType.REGULAR;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Транспорт: постановка в очередь новой картинки в синхронизированном баннере")
@Stories(StoriesNames.IMAGE_ACTION_CREATION)
@Features({FeatureNames.IMAGES, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class AddingToBsQueueOfNewPicInSyncedBannerTest extends SendingToBsQueueBannerBaseTest {

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
    }

    @Test
    @Title("Добавление в очередь ppc.bs_export_queue новой картинки в синхронизированном баннере")
    public void addingToBsQueueOfNewPicInSyncedBannerTest() {
        String[] imageHashes = helpSteps.addImagesForUserIfNotExists(login, REGULAR);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long bid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(bid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        api.userSteps.adsSteps()
                .adsUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(bid)
                                .withTextAd(new TextAdUpdateMap()
                                        .withAdImageHash(imageHashes[0]))));
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .setBannerImagesStatusModerateByBid(bid, BannerImagesStatusmoderate.Yes);

        setInSingleSendFlag(inSingleSend, shard, bid);

        api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .runBsExportMasterScript(shard, cid);
        BsExportQueueRecord campInExportQueue = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .transportSteps()
                .getBsExportQueueRecord(cid);
        assertThat("в таблице ppc.bs_export_queue присутствует запись для новой картинки " +
                        "в синхронизированном баннере",
                campInExportQueue,
                new QueueRecordMatcher()
                        .withoutCamps()
                        .withBanners()
                        .withContexts()
                        .withBids()
                        .withoutPrices());
    }
}
