package ru.yandex.autotests.directintapi.bstransport.main.image.actions.creation.queue;

import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BsExportQueueRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.tags.TestDomains;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.directapi.darkside.model.ImageType.REGULAR;
import static ru.yandex.autotests.directapi.darkside.model.Status.NO;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Tag(TestDomains.BsTransport.EXPORT_QUEUE)
@Title("Транспорт: удаление из очереди новой картинки " +
        "в новом баннере")
@Stories(StoriesNames.IMAGE_ACTION_CREATION)
@Features({FeatureNames.IMAGES, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class RemovingFromBsQueueOfNewPicInNewBannerTest extends SendingToBsQueueBannerBaseTest {

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }

    @Test
    @Title("Удаление из очереди ppc.bs_export_queue новой картинки в новом баннере")
    public void removingFromBsQueueOfNewPicInNewBannerTest() {
        String[] imageHashes = helpSteps.addImagesForUserIfNotExists(login, REGULAR);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long syncedBid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(syncedBid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .sendNewCampaign(shard, cid);

        Long picBid = api.userSteps.adsSteps()
                .addAd(new AdAddItemMap()
                        .withAdGroupId(pid)
                        .withTextAd(new TextAdAddMap()
                                .defaultTextAd()
                                .withAdImageHash(imageHashes[0])));
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(picBid);
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .setBannerImagesStatusModerateByBid(picBid, BannerImagesStatusmoderate.Yes);
        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, NO);

        setInSingleSendFlag(inSingleSend, shard, picBid);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .sendSyncedCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, cid);
        assumeThat("кампания отправлена", campaign, notNullValue());

        BsExportQueueRecord bsExportQueueRecord = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .transportSteps()
                .getBsExportQueueRecord(cid);
        assertThat("кампания удалена из очереди ppc.bs_export_queue",
                bsExportQueueRecord, nullValue());
    }
}
