package ru.yandex.autotests.directintapi.bstransport.main.image.actions.creation.queue;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.runners.Parameterized;

import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

public class SendingToBsQueueBannerBaseTest {

    protected static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    protected static final TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    protected static int shard;

    @Parameterized.Parameter
    public boolean inSingleSend;

    @Parameterized.Parameters(name = "Единый баннер для отправки = {0}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {false},
                {true},
        };
        return Arrays.asList(data);
    }

    protected void setInSingleSendFlag(boolean inSingleSend, int shard, long bid) {
        if (inSingleSend) {
            helpSteps.setImageOptsToSingleAdToBs(shard, bid);
        }
    }
}
