package ru.yandex.autotests.directintapi.bstransport.main.image.actions.creation.recieve;

import org.assertj.core.api.SoftAssertions;
import org.junit.BeforeClass;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.isEmptyOrNullString;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка изменений после успешной отправки " +
        "новой картинки в новом баннере")
@Stories(StoriesNames.IMAGE_ACTION_CREATION)
@Features({FeatureNames.IMAGES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsResponseHandlingForNewPicInNewBannerTest extends BsResponseHandlingForNewPicInNewBannerBaseTest {

    @BeforeClass
    public static void beforeClass() {
        prepareAndSendCampaign(false);
    }

    // кампания проверяется в тестах кампаний для аналогичного кейса
    // фраза проверяется в тестах фраз для аналогичного кейса

    @Test
    @Title("Изменения после успешной отправки новой картинки в новом баннере - " +
            "статус statusBsSynced Группы")
    public void testGroupSyncStatusAfterTransmissionOfNewPicInNewBanner() {
        PhrasesRecord dbGroup = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .adGroupsSteps()
                .getPhrases(pid);
        assertThat("после синхронизации группы statusBsSynced = Yes",
                dbGroup.getStatusbssynced().getLiteral(), equalTo(Status.YES));
    }

    @Test
    @Title("Изменения после успешной отправки новой картинки в новом баннере - " +
            "статус statusBsSynced Баннера")
    public void testBannerSyncStatusAfterTransmissionOfNewPicInNewBanner() {
        BannersRecord dbBanner = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bannersSteps()
                .getBanner(picBid);
        assertThat("после синхронизации баннера statusBsSynced = Yes",
                dbBanner.getStatusbssynced().getLiteral(), equalTo(Status.YES));
    }

    @Test
    @Title("Изменения после успешной отправки новой картинки в новом баннере - " +
            "BannerID Баннера")
    public void testBannerIdAfterTransmissionOfNewPicInNewBanner() {
        String bannerId = picBanner.getId();
        assumeThat("БК вернула BannerID в ответе на первый запрос",
                bannerId, not(isEmptyOrNullString()));

        Long dbBannerId = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bannersSteps()
                .getBanner(picBid)
                .getBannerid();
        assertThat("правильный BannerID у баннера после синхронизации",
                dbBannerId, equalTo(Long.valueOf(picBanner.getId())));
    }

    @Test
    @Title("Изменения после успешной отправки новой картинки в новом баннере - " +
            "BannerID Картинки")
    public void testPicIdAfterTransmissionOfNewPicInNewBanner() {
        String bannerId = pic.getId();
        assumeThat("БК вернула BannerID в ответе на первый запрос",
                bannerId, not(isEmptyOrNullString()));

        String dbBannerImageId = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .getBannerImagesByBid(picBid)
                .getBannerid().toString();
        SoftAssertions soft = new SoftAssertions();
        soft.assertThat(dbBannerImageId)
                .as("правильный BannerID у картинки после синхронизации")
                .isEqualTo(bannerId);

        Long dbBannerBsId = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bannersSteps()
                .getBanner(picBid)
                .getBannerid();
        soft.assertThat(dbBannerImageId)
                .as("Разные BannerID у картиночного и родительского баннеров")
                .isNotEqualTo(dbBannerBsId);
    }

    @Test
    @Title("Изменения после успешной отправки старой картинки в баннере - BannerID Картинки не меняется")
    public void testPicIdAfterTransmissionOfOldPicInBanner() {
        Long dbBannerImageBsId = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .getBannerImagesByBid(picBid2)
                .getBannerid();
        Long dbBannerBsId = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .bannersSteps()
                .getBanner(picBid2)
                .getBannerid();

        SoftAssertions soft = new SoftAssertions();
        soft.assertThat(dbBannerImageBsId)
                .as("BannerID у картиночного баннера после синхронизации не изменился")
                .isEqualTo(bsBannerId2);

        soft.assertThat(dbBannerBsId)
                .as("Разные BannerID у картиночного и родительского баннеров")
                .isNotEqualTo(dbBannerImageBsId);
        soft.assertAll();
    }
}
