package ru.yandex.autotests.directintapi.bstransport.main.image.actions.creation.transmit.moderation;

import java.util.List;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runners.Parameterized;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directapi.darkside.model.ImageType.REGULAR;
import static ru.yandex.autotests.directapi.darkside.model.Status.NO;
import static ru.yandex.autotests.directapi.darkside.model.Status.YES;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getMapValues;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

public class BsTransportOfNewPicInNewBannerWithNegBannerModerationBaseTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static final TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    private static int shard;

    private Long pid;
    private Long syncedBid;

    private Context context;
    private List<Phrase> phrases;
    private Banner picBanner;
    private Banner syncedBanner;
    private Banner pic;

    @Parameterized.Parameter
    public String testStatus;

    @Parameterized.Parameter(1)
    public boolean inSingleSend;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }

    @Before
    public void prepare() {
        String[] imageHashes = helpSteps.addImagesForUserIfNotExists(login, REGULAR);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        syncedBid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(syncedBid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps().getTransportSteps().sendNewCampaign(shard, cid);

        Long picBid = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(pid)
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withAdImageHash(imageHashes[0])));
        Long imageId = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .getBannerImagesByBid(picBid)
                .getImageId();
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .setBannerImagesStatusModerate(imageId, BannerImagesStatusmoderate.Yes);
        if (inSingleSend) {
            helpSteps.setImageOptsToSingleAdToBs(shard, picBid);
        }

        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusModerate(picBid, YES);
        api.userSteps.getDarkSideSteps().getBannersFakeSteps().setStatusPostModerate(picBid, testStatus);

        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, NO);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .sendSyncedCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        phrases = getMapValues(context != null ? context.getPhrases() : null);
        picBanner = context != null ? context.getBanner(picBid) : null;
        syncedBanner = context != null ? context.getBanner(syncedBid) : null;
        pic = context != null ? context.getBanner(imageId) : null;
    }

    @Test
    @Title("Не-отправка в БК новой картинки в новом баннере с непройденной модерацией (1 запрос) - " +
            "проверка объекта Контекст")
    public void testTransportOfContextObjReq1ForNewPicInNewBannerWithNegBannerModeration() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Не-отправка в БК новой картинки в новом баннере с непройденной модерацией (1 запрос) - " +
            "проверка списка Фраз")
    public void testTransportOfPhraseListReq1ForNewPicInNewBannerWithNegBannerModeration() {
        assertThat("в БК отправлен не пустой список фраз", phrases, not(empty()));
    }

    @Test
    @Title("Не-отправка в БК новой картинки в новом баннере с непройденной модерацией (1 запрос) - " +
            "проверка объекта Баннер (новый)")
    public void testTransportOfNewPicBannerReq1ForNewPicInNewBannerWithNegBannerModeration() {
        assertThat("в БК не отправлен новый баннер", picBanner, nullValue());
    }

    @Test
    @Title("Не-отправка в БК новой картинки в новом баннере с непройденной модерацией (1 запрос) - " +
            "проверка объекта Баннер (синхронизированный)")
    public void testTransportOfSyncedBannerReq1ForNewPicInNewBannerWithNegBannerModeration() {
        Banner expectedSyncedBanner = helpSteps.buildExpectedBannerObjFromDb(syncedBid, shard, UpdateInfo.SKIP);
        expectedSyncedBanner.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные остановленного баннера соответствуют ожидаемым",
                syncedBanner, beanEquals(expectedSyncedBanner));
    }

    @Test
    @Title("Не-отправка в БК новой картинки в новом баннере с непройденной модерацией (1 запрос) - " +
            "проверка объекта Картинка (новая в новом баннере)")
    public void testTransportOfNewPicReq1ForNewPicInNewBannerWithNegBannerModeration() {
        assertThat("в БК не отправлена новая картинка", pic, nullValue());
    }
}
