package ru.yandex.autotests.directintapi.bstransport.main.image.actions.creation.transmit.moderation;

import java.util.Arrays;
import java.util.Collection;

import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка не-отправки в БК новой картинки " +
        "в новом баннере с непройденной модерацией (1 запрос) (2)")
@Stories(StoriesNames.IMAGE_ACTION_CREATION)
@Features({FeatureNames.IMAGES, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class BsTransportOfNewPicInNewBannerWithNegBannerModerationTest2
        extends BsTransportOfNewPicInNewBannerWithNegBannerModerationBaseTest {

    @Parameterized.Parameters(name = "Статус statusPostModerate = {0}, единый баннер = {1}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {Status.SENT, false},
                {Status.NO, false},
                {Status.SENT, true},
                {Status.NO, true},
                // rejected - не проверяем, так как для нового баннера это не актуально
        };
        return Arrays.asList(data);
    }
}
