package ru.yandex.autotests.directintapi.bstransport.main.image.actions.creation.transmit.moderation;

import org.junit.BeforeClass;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка не-отправки в БК новой картинки " +
        "в отклоненном синхронизированном баннере (1 запрос), в едином баннере")
@Stories(StoriesNames.IMAGE_ACTION_CREATION)
@Features({FeatureNames.IMAGES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfNewPicInSyncedBannerWithNegBannerModerationWithSingleSendTest
        extends BsTransportOfNewPicInSyncedBannerWithNegBannerModerationBaseTest {

    @BeforeClass
    public static void beforeClass() {
        prepareAndSendCampaign(true);
    }

    @Test
    @Title("Не-отправка в БК новой картинки в отклоненном синхронизированном баннере (1 запрос) - " +
            "проверка объекта Контекст")
    public void testTransportOfContextObjReq1ForNewPicInNewBannerWithNegBannerModeration() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Не-отправка в БК новой картинки в отклоненном синхронизированном баннере (1 запрос) - " +
            "проверка списка Фраз")
    public void testTransportOfPhraseListReq1ForNewPicInNewBannerWithNegBannerModeration() {
        assertThat("в БК отправлен не пустой список фраз", phrases, not(empty()));
    }

    @Test
    @Title("Не-отправка в БК новой картинки в отклоненном синхронизированном баннере (1 запрос) - " +
            "проверка объекта Баннер (синхронизированный и отклоненный)")
    public void testTransportOfNewPicBannerReq1ForNewPicInNewBannerWithNegBannerModeration() {
        assertThat("в БК не отправлен новый баннер", picBanner, nullValue());
    }

    @Test
    @Title("Не-отправка в БК новой картинки в отклоненном синхронизированном баннере (1 запрос) - " +
            "проверка объекта Баннер (синхронизированный)")
    public void testTransportOfSyncedBannerReq1ForNewPicInNewBannerWithNegBannerModeration() {
        Banner expectedSyncedBanner = helpSteps.buildExpectedBannerObjFromDb(syncedBid1, shard, UpdateInfo.SKIP);
        expectedSyncedBanner.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные остановленного баннера соответствуют ожидаемым",
                syncedBanner, beanEquals(expectedSyncedBanner));
    }

    @Test
    @Title("Не-отправка в БК новой картинки в отклоненном синхронизированном баннере (1 запрос) - " +
            "проверка объекта Картинка (новая в синхронизированном отклоненном баннере)")
    public void testTransportOfNewPicReq1ForNewPicInNewBannerWithNegBannerModeration() {
        assertThat("в БК не отправлена новая картинка", pic, nullValue());
    }
}

