package ru.yandex.autotests.directintapi.bstransport.main.image.actions.creation.transmit.moderation;

import java.util.List;

import org.assertj.core.api.SoftAssertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runners.Parameterized;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.StopFlag;
import ru.yandex.autotests.directapi.darkside.model.bslogs.UpdateInfo;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Phrase;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.directapi.darkside.model.ImageType.REGULAR;
import static ru.yandex.autotests.directapi.darkside.model.Status.NO;
import static ru.yandex.autotests.directintapi.bstransport.TransportTestUtils.getMapValues;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

public class BsTransportOfNewPicInSyncedBannerWithNegPicModerationBaseTest {

    private static final String login = Logins.LOGIN_TRANSPORT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static final TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    @Parameterized.Parameter
    public BannerImagesStatusmoderate testStatus;

    @Parameterized.Parameter(1)
    public boolean inSingleSend;

    private static int shard;
    private Long pid;
    private Long picBid;
    private Context context;
    private List<Phrase> phrases;
    private Banner picBanner;
    private Banner pic;

    @BeforeClass
    public static void beforeClass() {
        shard = api.userSteps.clientFakeSteps().getUserShard(login);
    }

    @Before
    public void prepare() {
        String[] imageHashes = helpSteps.addImagesForUserIfNotExists(login, REGULAR);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        picBid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(picBid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .sendNewCampaign(shard, cid);

        api.userSteps.adsSteps()
                .adsUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(picBid)
                                .withTextAd(new TextAdUpdateMap()
                                        .withAdImageHash(imageHashes[0]))));
        Long imageId = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .getBannerImagesByBid(picBid)
                .getImageId();
        // выставляем тестовый статус модерации
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .setBannerImagesStatusModerate(imageId, testStatus);
        if (inSingleSend) {
            helpSteps.setImageOptsToSingleAdToBs(shard, picBid);
        }

        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, NO);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .sendSyncedCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, cid);
        context = campaign != null ? campaign.getContext(pid) : null;
        phrases = getMapValues(context != null ? context.getPhrases() : null);
        picBanner = context != null ? context.getBanner(picBid) : null;
        pic = context != null ? context.getBanner(imageId) : null;
    }

    @Test
    @Title("Не-отправка в БК новой картинки с непройденной модерацией в синхронизированном баннере  (1 запрос) - " +
            "проверка объекта Контекст")
    public void testTransportOfContextObjReq1ForNewPicInSyncedBannerWithNegPicModeration() {
        Context expectedContext = helpSteps.buildExpectedContextObjFromDb(pid, shard, UpdateInfo.UPDATE);
        assertThat("отправленные в БК данные группы соответствуют ожидаемым",
                context, beanEquals(expectedContext));
    }

    @Test
    @Title("Не-отправка в БК новой картинки с непройденной модерацией в синхронизированном баннере (1 запрос) - " +
            "проверка списка Фраз")
    public void testTransportOfPhraseListReq1ForNewPicInSyncedBannerWithNegPicModeration() {
        assertThat("в БК отправлен не пустой список фраз", phrases, not(empty()));
    }

    @Test
    @Title("Не-отправка в БК новой картинки с непройденной модерацией в синхронизированном баннере (1 запрос) - " +
            "проверка объекта Баннер (синхронизированный)")
    public void testTransportOfNewPicBannerReq1ForNewPicInSyncedBannerWithNegPicModeration() {
        Banner expectedPicBanner = helpSteps.buildExpectedBannerObjFromDb(picBid, shard, UpdateInfo.UPDATE);
        expectedPicBanner.setStop(StopFlag.RESUME.value());
        assertThat("отправленные в БК данные нового баннера соответствуют ожидаемым",
                picBanner, beanEquals(expectedPicBanner));
    }

    @Test
    @Title("Не-отправка в БК новой картинки с непройденной модерацией в синхронизированном баннере (1 запрос) - " +
            "проверка объекта Картинка (новая в синхронизированном баннере)")
    public void testTransportOfNewPicReq1ForNewPicInSyncedBannerWithNegPicModeration() {
        SoftAssertions soft = new SoftAssertions();
        if (inSingleSend) {
            soft.assertThat(picBanner.getImages())
                    .as("у баннера нет Images")
                    .isNull();
            soft.assertThat(picBanner.getResources().getAutoVideoCreative()).
                    as("у баннера нет AutoVideoCreative")
                    .isNull();
            soft.assertThat(picBanner.getIsAutoVideo())
                    .as("у баннера нет IsAutoVideo")
                    .isNull();
            soft.assertThat(picBanner.getImageType())
                    .as("у баннера нет ImageType")
                    .isNull();
        }
        soft.assertThat(pic)
                .as("картиночная версия баннера не отправилась в БК")
                .isNull();
        soft.assertAll();
    }
}
