package ru.yandex.autotests.directintapi.bstransport.main.image.actions.creation.transmit.moderation;

import java.util.Arrays;
import java.util.Collection;

import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

@Aqua.Test
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.RELEASE)
@Title("Транспорт: проверка не-отправки в БК новой картинки с непройденной модерацией " +
        "в синхронизированном баннере (1 запрос) (3)")
@Stories(StoriesNames.IMAGE_ACTION_CREATION)
@Features({FeatureNames.IMAGES, FeatureNames.NOT_FOR_FULL_EXPORT})
@RunWith(Parameterized.class)
public class BsTransportOfNewPicInSyncedBannerWithNegPicModerationTest3
        extends BsTransportOfNewPicInSyncedBannerWithNegPicModerationBaseTest {

    @Parameterized.Parameters(name = "Статус statusModerate = {0}, единый баннер = {1}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {BannerImagesStatusmoderate.No, false},
                {BannerImagesStatusmoderate.No, true},
        };
        return Arrays.asList(data);
    }
}
