package ru.yandex.autotests.directintapi.bstransport.main.image.actions.creation.transmit.req1;

import org.junit.ClassRule;
import org.junit.Rule;

import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.darkside.connection.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.RunBsTransportScriptResponse;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Banner;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Campaign;
import ru.yandex.autotests.directapi.darkside.model.bslogs.clientdata.Context;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directintapi.bstransport.TransportHelpSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsNull.notNullValue;
import static org.hamcrest.core.IsNull.nullValue;
import static ru.yandex.autotests.directapi.darkside.model.Status.NO;
import static ru.yandex.autotests.directapi.enums.ImageType.REGULAR;
import static ru.yandex.autotests.directapi.enums.ImageType.WIDE;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

public class BsTransportOfChangedPicToWideInBannerBaseTest {
    public static final String LOGIN = Logins.LOGIN_TRANSPORT_IMG;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    protected static final TransportHelpSteps helpSteps = new TransportHelpSteps(api);

    protected static Banner pic;
    protected static Banner picBanner;

    protected static void prepareAndSendCampaign(boolean inSingleSend) {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);

        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long pid = api.userSteps.adGroupsSteps().addDefaultGroup(cid);
        Long textBid = api.userSteps.adsSteps().addDefaultTextAd(pid);
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(pid);
        api.userSteps.campaignFakeSteps().makeNewCampaignReadyForSendingToBS(cid);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(pid);
        api.userSteps.bannersFakeSteps().makeBannerFullyModerated(textBid);
        api.userSteps.phrasesFakeSteps().makeKeywordModerated(keywordId);

        //Цепляем разыные картинки пользователю
        String wideImageHash = api.userSteps
                .imagesSteps()
                .configLoginImages(LOGIN, WIDE, true, 1)[0];
        String smallImageHash = api.userSteps
                .imagesSteps()
                .configLoginImages(LOGIN, REGULAR, false, 1)[0];

        //Прикрепляем обычную картинку к баннеру
        api.userSteps.adsSteps()
                .adsUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(textBid)
                                .withTextAd(new TextAdUpdateMap()
                                        .withAdImageHash(smallImageHash))));
        Long imageId = api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .getBannerImagesByBid(textBid)
                .getImageId();
        api.userSteps.getDirectJooqDbSteps().useShard(shard)
                .imagesSteps()
                .setBannerImagesStatusModerate(imageId, BannerImagesStatusmoderate.Yes);
        if (inSingleSend) {
            helpSteps.setImageOptsToSingleAdToBs(shard, textBid);
        }

        // имитируем поведение модерации DIRECT-33440
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, NO);

        RunBsTransportScriptResponse resp = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .sendNewCampaign(shard, cid);
        Campaign campaign = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, cid);
        Context context = campaign.getContext(pid);
        assumeThat("в БК отправлен непустой Context", context, notNullValue());
        pic = context.getBanner(imageId);
        picBanner = context.getBanner(textBid);
        assumeThat("Отправка в БК картиночной версии баннера",
                pic, inSingleSend ? nullValue() : notNullValue());
        assumeThat("в БК отправился текстовый баннер",
                picBanner, notNullValue());

        //Меняем картинку баннера на Wide
        api.userSteps.adsSteps()
                .adsUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(textBid)
                                .withTextAd(new TextAdUpdateMap()
                                        .withAdImageHash(wideImageHash))));
        imageId = api.userSteps.getDirectJooqDbSteps()
                .useShard(shard)
                .imagesSteps()
                .getBannerImagesByBid(textBid)
                .getImageId();
        api.userSteps.getDirectJooqDbSteps()
                .useShard(shard)
                .imagesSteps()
                .setBannerImagesStatusModerate(imageId, BannerImagesStatusmoderate.Yes);

        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(pid, NO);

        //Переотправляем все
        resp = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .sendSyncedCampaign(shard, cid);
        campaign = api.userSteps.getDarkSideSteps()
                .getTransportSteps()
                .getClientDataRequestCampaign(resp, 0, cid);
        context = campaign.getContext(pid);
        assumeThat("в БК отправлен непустой Context", context, notNullValue());
        pic = context.getBanner(imageId);
        picBanner = context.getBanner(textBid);
        assumeThat("Отправка в БК картиночной версии баннера",
                pic, inSingleSend ? nullValue() : notNullValue());
        assumeThat("в БК отправился текстовый баннер",
                picBanner, notNullValue());
    }
}
