package ru.yandex.autotests.directintapi.bstransport.main.image.actions.creation.transmit.req1;

import org.junit.BeforeClass;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directintapi.bstransport.FeatureNames;
import ru.yandex.autotests.directintapi.bstransport.StoriesNames;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;

import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;


/**
 * Created by buhter on 08/02/16.
 * https://st.yandex-team.ru/TESTIRT-8458
 */

@Aqua.Test
@Tag(TagDictionary.RELEASE)
@Issue("https://st.yandex-team.ru/DIRECT-50792")
@Title("Транспорт: проверка отправки в БК картинки после изменения ее типа на wide")
@Stories(StoriesNames.IMAGE_ACTION_CREATION)
@Features({FeatureNames.IMAGES, FeatureNames.NOT_FOR_FULL_EXPORT})
public class BsTransportOfChangedPicToWideInBannerTest extends BsTransportOfChangedPicToWideInBannerBaseTest {

    @BeforeClass
    @Step("Подготовка тестовых данных")
    public static void prepare() {
        prepareAndSendCampaign(false);
    }

    @Test
    public void testTransportOfBannerWithWideImageStopped() {
        assertThat("в БК отправился включенный баннер с wide картинкой",
                pic.getStop(), equalTo(0));
    }

    @Test
    public void testTransportOfTextBannerActive() {
        assertThat("в БК отправился включенный текстовый баннер",
                picBanner.getStop(), equalTo(0));
    }
}
